/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm.ant;

import gr.spinellis.ckjm.MetricsFilter;
import gr.spinellis.ckjm.PrintPlainResults;
import gr.spinellis.ckjm.ant.PrintXmlResults;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class CkjmTask
extends MatchingTask {
    private File outputFile;
    private File classDir;
    private Path extdirs;
    private String format = "plain";

    public void setFormat(String format) {
        this.format = format;
    }

    public void setOutputfile(File outputfile) {
        this.outputFile = outputfile;
    }

    public void setClassdir(File classDir) {
        this.classDir = classDir;
    }

    public void setExtdirs(Path e) {
        if (this.extdirs == null) {
            this.extdirs = e;
        } else {
            this.extdirs.append(e);
        }
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.getProject());
        }
        return this.extdirs.createPath();
    }

    public void execute() throws BuildException {
        DirectoryScanner ds;
        String[] files;
        if (this.classDir == null) {
            throw new BuildException("classdir attribute must be set!");
        }
        if (!this.classDir.exists()) {
            throw new BuildException("classdir does not exist!");
        }
        if (!this.classDir.isDirectory()) {
            throw new BuildException("classdir is not a directory!");
        }
        if (this.extdirs != null && this.extdirs.size() > 0) {
            if (System.getProperty("java.ext.dirs").length() == 0) {
                System.setProperty("java.ext.dirs", this.extdirs.toString());
            } else {
                System.setProperty("java.ext.dirs", System.getProperty("java.ext.dirs") + File.pathSeparator + this.extdirs);
            }
        }
        if ((files = (ds = super.getDirectoryScanner(this.classDir)).getIncludedFiles()).length == 0) {
            this.log("No class files in specified directory " + this.classDir);
        } else {
            for (int i = 0; i < files.length; ++i) {
                files[i] = this.classDir.getPath() + File.separatorChar + files[i];
            }
            try {
                FileOutputStream outputStream = new FileOutputStream(this.outputFile);
                if (this.format.equals("xml")) {
                    PrintXmlResults outputXml = new PrintXmlResults(new PrintStream(outputStream));
                    outputXml.printHeader();
                    MetricsFilter.runMetrics(files, outputXml);
                    outputXml.printFooter();
                } else {
                    PrintPlainResults outputPlain = new PrintPlainResults(new PrintStream(outputStream));
                    MetricsFilter.runMetrics(files, outputPlain);
                }
                ((OutputStream)outputStream).close();
            }
            catch (IOException ioe) {
                throw new BuildException("Error file handling: " + ioe.getMessage());
            }
        }
    }
}

