/*
 * Decompiled with CFR 0.152.
 */
package gr.spinellis.ckjm;

import gr.spinellis.ckjm.ClassMetrics;
import gr.spinellis.ckjm.ClassMetricsContainer;
import gr.spinellis.ckjm.MethodVisitor;
import gr.spinellis.ckjm.MetricsFilter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Type;

public class ClassVisitor
extends EmptyVisitor {
    private JavaClass visitedClass;
    private ConstantPoolGen cp;
    private String myClassName;
    private ClassMetricsContainer cmap;
    private ClassMetrics cm;
    private HashSet<String> efferentCoupledClasses = new HashSet();
    private HashSet<String> responseSet = new HashSet();
    ArrayList<TreeSet<String>> mi = new ArrayList();

    public ClassVisitor(JavaClass jc, ClassMetricsContainer classMap) {
        this.visitedClass = jc;
        this.cp = new ConstantPoolGen(this.visitedClass.getConstantPool());
        this.cmap = classMap;
        this.myClassName = jc.getClassName();
        this.cm = this.cmap.getMetrics(this.myClassName);
    }

    public ClassMetrics getMetrics() {
        return this.cm;
    }

    public void start() {
        this.visitJavaClass(this.visitedClass);
    }

    public void visitJavaClass(JavaClass jc) {
        String super_name = jc.getSuperclassName();
        String package_name = jc.getPackageName();
        this.cm.setVisited();
        if (jc.isPublic()) {
            this.cm.setPublic();
        }
        ClassMetrics pm = this.cmap.getMetrics(super_name);
        pm.incNoc();
        try {
            this.cm.setDit(jc.getSuperClasses().length);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Error obtaining all superclasses of " + jc);
        }
        this.registerCoupling(super_name);
        String[] ifs = jc.getInterfaceNames();
        for (int i = 0; i < ifs.length; ++i) {
            this.registerCoupling(ifs[i]);
        }
        Field[] fields = jc.getFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].accept((Visitor)this);
        }
        Method[] methods = jc.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            methods[i].accept((Visitor)this);
        }
    }

    public void registerCoupling(String className) {
        if (!(!MetricsFilter.isJdkIncluded() && ClassMetrics.isJdkClass(className) || this.myClassName.equals(className))) {
            this.efferentCoupledClasses.add(className);
            this.cmap.getMetrics(className).addAfferentCoupling(this.myClassName);
        }
    }

    public void registerCoupling(Type t) {
        this.registerCoupling(ClassVisitor.className(t));
    }

    void registerFieldAccess(String className, String fieldName) {
        this.registerCoupling(className);
        if (className.equals(this.myClassName)) {
            this.mi.get(this.mi.size() - 1).add(fieldName);
        }
    }

    void registerMethodInvocation(String className, String methodName, Type[] args) {
        this.registerCoupling(className);
        this.incRFC(className, methodName, args);
    }

    public void visitField(Field field) {
        this.registerCoupling(field.getType());
    }

    private void incRFC(String className, String methodName, Type[] arguments) {
        String argumentList = Arrays.asList(arguments).toString();
        String args = argumentList.substring(1, argumentList.length() - 1);
        String signature = className + "." + methodName + "(" + args + ")";
        this.responseSet.add(signature);
    }

    public void visitMethod(Method method) {
        MethodGen mg = new MethodGen(method, this.visitedClass.getClassName(), this.cp);
        Type result_type = mg.getReturnType();
        Type[] argTypes = mg.getArgumentTypes();
        this.registerCoupling(mg.getReturnType());
        for (int i = 0; i < argTypes.length; ++i) {
            this.registerCoupling(argTypes[i]);
        }
        String[] exceptions = mg.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            this.registerCoupling(exceptions[i]);
        }
        this.incRFC(this.myClassName, method.getName(), argTypes);
        this.cm.incWmc();
        if (Modifier.isPublic(method.getModifiers())) {
            this.cm.incNpm();
        }
        this.mi.add(new TreeSet());
        MethodVisitor factory = new MethodVisitor(mg, this);
        factory.start();
    }

    static String className(Type t) {
        String ts = t.toString();
        if (t.getType() <= 12) {
            return "java.PRIMITIVE";
        }
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            return ClassVisitor.className(at.getBasicType());
        }
        return t.toString();
    }

    public void end() {
        this.cm.setCbo(this.efferentCoupledClasses.size());
        this.cm.setRfc(this.responseSet.size());
        int lcom = 0;
        for (int i = 0; i < this.mi.size(); ++i) {
            for (int j = i + 1; j < this.mi.size(); ++j) {
                TreeSet intersection = (TreeSet)this.mi.get(i).clone();
                intersection.retainAll((Collection)this.mi.get(j));
                if (intersection.size() == 0) {
                    ++lcom;
                    continue;
                }
                --lcom;
            }
        }
        this.cm.setLcom(lcom > 0 ? lcom : 0);
    }
}

