/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.NullMemoryIO;
import org.jruby.ext.ffi.SwappedMemoryIO;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Pointer"}, parent="AbstractMemory")
public class Pointer
extends AbstractMemory {
    public static RubyClass createPointerClass(Ruby runtime2, RubyModule module) {
        RubyClass result = module.defineClassUnder("Pointer", module.getClass("AbstractMemory"), PointerAllocator.INSTANCE);
        result.defineAnnotatedMethods(Pointer.class);
        result.defineAnnotatedConstants(Pointer.class);
        module.defineClassUnder("NullPointerError", runtime2.getRuntimeError(), runtime2.getRuntimeError().getAllocator());
        result.fastSetConstant("NULL", new Pointer(runtime2, result, new NullMemoryIO(runtime2)));
        return result;
    }

    public static final Pointer getNull(Ruby runtime2) {
        return (Pointer)runtime2.fastGetModule("FFI").fastGetClass("Pointer").fastGetConstant("NULL");
    }

    Pointer(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz, new NullMemoryIO(runtime2), 0L);
    }

    public Pointer(Ruby runtime2, DirectMemoryIO io2) {
        this(runtime2, Pointer.getPointerClass(runtime2), io2);
    }

    public Pointer(Ruby runtime2, DirectMemoryIO io2, long size2, int typeSize) {
        this(runtime2, Pointer.getPointerClass(runtime2), io2, size2, typeSize);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, DirectMemoryIO io2) {
        super(runtime2, klass, io2, Long.MAX_VALUE);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, DirectMemoryIO io2, long size2) {
        super(runtime2, klass, io2, size2);
    }

    protected Pointer(Ruby runtime2, RubyClass klass, DirectMemoryIO io2, long size2, int typeSize) {
        super(runtime2, klass, io2, size2, typeSize);
    }

    public static final RubyClass getPointerClass(Ruby runtime2) {
        return runtime2.fastGetModule("FFI").fastGetClass("Pointer");
    }

    public final AbstractMemory order(Ruby runtime2, ByteOrder order2) {
        return new Pointer(runtime2, order2.equals(this.getMemoryIO().order()) ? (DirectMemoryIO)this.getMemoryIO() : new SwappedMemoryIO(runtime2, this.getMemoryIO()), this.size, this.typeSize);
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject address2) {
        this.io = address2 instanceof Pointer ? ((Pointer)address2).getMemoryIO() : Factory.getInstance().wrapDirectMemory(context.getRuntime(), RubyFixnum.num2long(address2));
        this.size = Long.MAX_VALUE;
        this.typeSize = 1;
        return this;
    }

    @JRubyMethod(name={"initialize"})
    public IRubyObject initialize(ThreadContext context, IRubyObject type2, IRubyObject address2) {
        this.io = address2 instanceof Pointer ? ((Pointer)address2).getMemoryIO() : Factory.getInstance().wrapDirectMemory(context.getRuntime(), RubyFixnum.num2long(address2));
        this.size = Long.MAX_VALUE;
        this.typeSize = Pointer.calculateTypeSize(context, type2);
        return this;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this;
        }
        Pointer orig = (Pointer)other;
        this.typeSize = orig.typeSize;
        this.size = orig.size;
        this.setMemoryIO(orig.getMemoryIO().dup());
        return this;
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return context.getRuntime().newBoolean(this.getMemoryIO().isNull());
    }

    @JRubyMethod(name={"to_s", "inspect"}, optional=1)
    public IRubyObject to_s(ThreadContext context, IRubyObject[] args2) {
        String s2 = this.size != Long.MAX_VALUE ? String.format("#<%s address=0x%x size=%s>", this.getMetaClass().getName(), this.getAddress(), this.size) : String.format("#<%s address=0x%x>", this.getMetaClass().getName(), this.getAddress());
        return RubyString.newString(context.getRuntime(), s2);
    }

    @JRubyMethod(name={"address", "to_i"})
    public IRubyObject address(ThreadContext context) {
        return context.getRuntime().newFixnum(this.getAddress());
    }

    public final long getAddress() {
        return ((DirectMemoryIO)this.getMemoryIO()).getAddress();
    }

    protected AbstractMemory slice(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), (DirectMemoryIO)this.getMemoryIO().slice(offset2), this.size == Long.MAX_VALUE ? Long.MAX_VALUE : this.size - offset2, this.typeSize);
    }

    protected AbstractMemory slice(Ruby runtime2, long offset2, long size2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), (DirectMemoryIO)this.getMemoryIO().slice(offset2, size2), size2, this.typeSize);
    }

    protected Pointer getPointer(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, Pointer.getPointerClass(runtime2), this.getMemoryIO().getMemoryIO(offset2), Long.MAX_VALUE);
    }

    private static final class PointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new PointerAllocator();

        private PointerAllocator() {
        }

        public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
            return new Pointer(runtime2, klazz);
        }
    }
}

