/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.compiler.ir.Interp;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YieldInstr
extends Instr {
    Operand yieldArg;

    public YieldInstr(Variable result, Operand arg2) {
        super(Operation.YIELD, result);
        this.yieldArg = arg2;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return this;
    }

    @Override
    @Interp
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        IRubyObject resultValue = this.yieldArg == null ? interp.getBlock().call(interp.getContext()) : interp.getBlock().yield(interp.getContext(), (IRubyObject)this.yieldArg.retrieve(interp));
        this.getResult().store(interp, resultValue);
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.yieldArg + ")";
    }

    @Override
    public Operand[] getOperands() {
        Operand[] operandArray;
        if (this.yieldArg == null) {
            operandArray = new Operand[]{};
        } else {
            Operand[] operandArray2 = new Operand[1];
            operandArray = operandArray2;
            operandArray2[0] = this.yieldArg;
        }
        return operandArray;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        if (this.yieldArg != null) {
            this.yieldArg = this.yieldArg.getSimplifiedOperand(valueMap);
        }
    }
}

