/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.checks.templates;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.sonar.api.checks.templates.AnnotationCheckTemplateFactory;
import org.sonar.api.checks.templates.CheckTemplate;
import org.sonar.api.checks.templates.CheckTemplateProperty;
import org.sonar.api.checks.templates.XmlCheckTemplateFactory;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Language;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.RulesRepository;
import org.sonar.check.Priority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CheckTemplateRepository
implements RulesRepository {
    private String key;
    private Language language;
    private List<CheckTemplate> templates;
    private Map<String, CheckTemplate> templatesByKey;

    public CheckTemplateRepository() {
    }

    public CheckTemplateRepository(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key can not be null");
        }
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public CheckTemplateRepository setKey(String key) {
        this.key = key;
        return this;
    }

    public Language getLanguage() {
        return this.language;
    }

    public CheckTemplateRepository setLanguage(Language l) {
        this.language = l;
        return this;
    }

    public List<CheckTemplate> getTemplates() {
        if (this.templates == null) {
            return Collections.emptyList();
        }
        return this.templates;
    }

    public CheckTemplateRepository setTemplates(List<CheckTemplate> c) {
        this.templates = c;
        return this;
    }

    public CheckTemplate getTemplate(String key) {
        if (this.templatesByKey == null || this.templatesByKey.isEmpty()) {
            this.templatesByKey = new HashMap<String, CheckTemplate>();
            for (CheckTemplate template : this.templates) {
                this.templatesByKey.put(template.getKey(), template);
            }
        }
        return this.templatesByKey.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckTemplateRepository that = (CheckTemplateRepository)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CheckTemplateRepository createFromXml(String repositoryKey, Language language, String pathToXml) {
        InputStream input = CheckTemplateRepository.class.getResourceAsStream(pathToXml);
        try {
            List<CheckTemplate> templates = new XmlCheckTemplateFactory().parse(input);
            CheckTemplateRepository repository = new CheckTemplateRepository(repositoryKey);
            repository.setTemplates(templates);
            repository.setLanguage(language);
            CheckTemplateRepository checkTemplateRepository = repository;
            return checkTemplateRepository;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public static CheckTemplateRepository createFromAnnotatedClasses(String repositoryKey, Language language, Collection<Class> classes) {
        AnnotationCheckTemplateFactory factory = new AnnotationCheckTemplateFactory(classes);
        CheckTemplateRepository repository = new CheckTemplateRepository(repositoryKey);
        repository.setTemplates(factory.create());
        repository.setLanguage(language);
        return repository;
    }

    @Override
    public List<Rule> getInitialReferential() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (CheckTemplate checkTemplate : this.getTemplates()) {
            rules.add(this.toRule(checkTemplate));
        }
        return rules;
    }

    private Rule toRule(CheckTemplate checkTemplate) {
        Rule rule = new Rule(this.getKey(), checkTemplate.getKey());
        rule.setDescription(checkTemplate.getDescription(Locale.ENGLISH));
        rule.setName(checkTemplate.getTitle(Locale.ENGLISH));
        rule.setSeverity(RulePriority.fromCheckPriority((Priority)checkTemplate.getPriority()));
        for (CheckTemplateProperty checkTemplateProperty : checkTemplate.getProperties()) {
            RuleParam param = rule.createParameter(checkTemplateProperty.getKey());
            param.setDescription(checkTemplateProperty.getDescription(Locale.ENGLISH));
            param.setType("s");
        }
        return rule;
    }

    @Override
    public List<Rule> parseReferential(String fileContent) {
        return Collections.emptyList();
    }

    @Override
    public List<RulesProfile> getProvidedProfiles() {
        return Collections.emptyList();
    }
}

