/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.tag;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceTagConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    private static final String LABEL_PATTERN = "^Label ([^ ]+) saved.$";
    private static final String SYNC_PATTERN = "^([^#]+)#\\d+ - (.*)";
    public static final int STATE_CREATE = 1;
    public static final int STATE_SYNC = 2;
    public static final int STATE_ERROR = 3;
    private int currentState = 1;
    private List tagged = new ArrayList();
    private RE syncRegexp;

    public PerforceTagConsumer() {
        try {
            this.syncRegexp = new RE(SYNC_PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public List getTagged() {
        return this.tagged;
    }

    public void consumeLine(String line) {
        switch (this.currentState) {
            case 1: {
                if (!new RE(LABEL_PATTERN).match(line)) {
                    this.error(line);
                    break;
                }
                this.currentState = 2;
                break;
            }
            case 2: {
                if (!this.syncRegexp.match(line)) {
                    this.error(line);
                    break;
                }
                this.tagged.add(this.syncRegexp.getParen(1));
                break;
            }
            default: {
                this.error(line);
            }
        }
    }

    private void error(String line) {
        this.currentState = 3;
        this.output.println(line);
    }

    public boolean isSuccess() {
        return this.currentState == 2;
    }
}

