/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.login;

import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.apache.regexp.RE;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceLoginConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    private static final String LOGIN_PATTERN = "^User [^ ]+ logged in.$";
    public static final int STATE_LOGIN = 1;
    public static final int STATE_ERROR = 2;
    private int currentState = 1;

    public void consumeLine(String line) {
        if (line.startsWith("Enter password:")) {
            return;
        }
        if (this.currentState != 2 && new RE(LOGIN_PATTERN).match(line)) {
            return;
        }
        this.error(line);
    }

    private void error(String line) {
        this.currentState = 2;
        this.output.println(line);
    }

    public boolean isSuccess() {
        return this.currentState == 1;
    }
}

