/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.remove;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitRemoveConsumer
implements StreamConsumer {
    private static final String REMOVED_PATTERN = "^rm\\s'(.*)'";
    private ScmLogger logger;
    private List<ScmFile> removedFiles = new ArrayList<ScmFile>();
    private RE removedRegexp;

    public GitRemoveConsumer(ScmLogger logger) {
        this.logger = logger;
        try {
            this.removedRegexp = new RE(REMOVED_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public void consumeLine(String line) {
        if (line.length() <= 2) {
            return;
        }
        if (!this.removedRegexp.match(line)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("could not parse line: " + line);
            }
            return;
        }
        String file = this.removedRegexp.getParen(1);
        this.removedFiles.add(new ScmFile(file, ScmFileStatus.DELETED));
    }

    public List<ScmFile> getRemovedFiles() {
        return this.removedFiles;
    }
}

