/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.update;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.update.GitUpdateCommandConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitUpdateCommand
extends AbstractUpdateCommand
implements GitCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion scmVersion) throws ScmException {
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if ("file".equals(repository.getProtocol()) && repository.getUrl().indexOf(fileSet.getBasedir().getPath()) >= 0) {
            throw new ScmException("remote repository must not be the working directory");
        }
        GitUpdateCommandConsumer consumer = new GitUpdateCommandConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "pull");
        cl.createArg().setLine("origin");
        cl.createArg().setLine("master");
        int exitCode = GitCommandLineUtils.execute(cl, (StreamConsumer)consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            this.getLogger().warn("failed to update git, return code " + exitCode);
            return new UpdateScmResult(cl.toString(), "The git-pull origin master command failed.", stderr.getOutput(), false);
        }
        return new UpdateScmResultWithRevision(cl.toString(), consumer.getUpdatedFiles(), null);
    }

    protected ChangeLogCommand getChangeLogCommand() {
        return null;
    }
}

