/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.clearcase.command.update;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.clearcase.command.ClearCaseCommand;
import org.apache.maven.scm.provider.clearcase.command.changelog.ClearCaseChangeLogCommand;
import org.apache.maven.scm.provider.clearcase.command.update.ClearCaseUpdateConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ClearCaseUpdateCommand
extends AbstractUpdateCommand
implements ClearCaseCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        this.getLogger().debug("executing update command...");
        Commandline cl = ClearCaseUpdateCommand.createCommandLine(fileSet);
        ClearCaseUpdateConsumer consumer = new ClearCaseUpdateConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            this.getLogger().debug("Executing: " + cl.getWorkingDirectory().getAbsolutePath() + ">>" + cl.toString());
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing clearcase command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new UpdateScmResult(cl.toString(), "The cleartool command failed.", stderr.getOutput(), false);
        }
        return new UpdateScmResult(cl.toString(), consumer.getUpdatedFiles());
    }

    protected ChangeLogCommand getChangeLogCommand() {
        ClearCaseChangeLogCommand changeLogCmd = new ClearCaseChangeLogCommand();
        changeLogCmd.setLogger(this.getLogger());
        return changeLogCmd;
    }

    public static Commandline createCommandLine(ScmFileSet scmFileSet) {
        Commandline command = new Commandline();
        File workingDirectory = scmFileSet.getBasedir();
        command.setWorkingDirectory(workingDirectory.getAbsolutePath());
        command.setExecutable("cleartool");
        command.createArgument().setValue("update");
        return command;
    }
}

