/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class ScmFileSet {
    private static final String DEFAULT_EXCLUDES = StringUtils.join((Object[])DirectoryScanner.DEFAULTEXCLUDES, (String)",");
    private File basedir;
    private String includes;
    private String excludes;
    private List files = new ArrayList(0);

    public ScmFileSet(File basedir) {
        this(basedir, new ArrayList(0));
    }

    public ScmFileSet(File basedir, File file) {
        this(basedir, new File[]{file});
    }

    public ScmFileSet(File basedir, String includes, String excludes) throws IOException {
        this.basedir = basedir;
        excludes = excludes != null && excludes.length() > 0 ? excludes + "," + DEFAULT_EXCLUDES : DEFAULT_EXCLUDES;
        this.files = FileUtils.getFiles((File)basedir, (String)includes, (String)excludes, (boolean)false);
        this.includes = includes;
        this.excludes = excludes;
    }

    public ScmFileSet(File basedir, String includes) throws IOException {
        this(basedir, includes, null);
    }

    public ScmFileSet(File basedir, File[] files) {
        this(basedir, Arrays.asList(files));
    }

    public ScmFileSet(File basedir, List files) {
        if (basedir == null) {
            throw new NullPointerException("basedir must not be null");
        }
        if (files == null) {
            throw new NullPointerException("files must not be null");
        }
        this.basedir = basedir;
        this.files = files;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File[] getFiles() {
        return this.files.toArray(new File[0]);
    }

    public List getFileList() {
        return this.files;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String toString() {
        return "basedir = " + this.basedir + "; files = " + this.files;
    }
}

