/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader;
import org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Writer;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.site.AbstractSiteMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class SiteDescriptorAttachMojo
extends AbstractSiteMojo {
    private File basedir;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        List localesList = this.siteTool.getAvailableLocales(this.locales);
        for (Locale locale : localesList) {
            DecorationModel decoration;
            File descriptorFile = this.siteTool.getSiteDescriptorFromBasedir(SiteDescriptorAttachMojo.toRelative(this.project.getBasedir(), this.siteDirectory.getAbsolutePath()), this.basedir, locale);
            if (!descriptorFile.exists()) continue;
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("reports", "<menu ref=\"reports\"/>");
            props.put("modules", "<menu ref=\"modules\"/>");
            try {
                String siteDescriptorContent = IOUtil.toString((Reader)ReaderFactory.newXmlReader((File)descriptorFile));
                siteDescriptorContent = this.siteTool.getInterpolatedSiteDescriptorContent(props, this.project, siteDescriptorContent, this.getInputEncoding(), this.getOutputEncoding());
                decoration = new DecorationXpp3Reader().read((Reader)new StringReader(siteDescriptorContent));
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Error parsing site descriptor", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading site descriptor", (Exception)e);
            }
            catch (SiteToolException e) {
                throw new MojoExecutionException("Error when interpolating site descriptor", (Exception)((Object)e));
            }
            MavenProject parentProject = this.siteTool.getParentProject(this.project, this.reactorProjects, this.localRepository);
            if (parentProject != null && this.project.getUrl() != null && parentProject.getUrl() != null) {
                this.siteTool.populateParentMenu(decoration, locale, this.project, parentProject, true);
            }
            try {
                this.siteTool.populateModulesMenu(this.project, this.reactorProjects, this.localRepository, decoration, locale, true);
            }
            catch (SiteToolException e) {
                throw new MojoExecutionException("Error when populating modules", (Exception)((Object)e));
            }
            String classifier = null;
            int index = descriptorFile.getName().lastIndexOf(46);
            if (index <= 0) {
                throw new MojoExecutionException("Unable to determine the classifier to use");
            }
            classifier = descriptorFile.getName().substring(0, index);
            String filename = this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + descriptorFile.getName();
            File interpolatedDescriptorFile = new File(this.project.getBuild().getDirectory(), filename);
            interpolatedDescriptorFile.getParentFile().mkdirs();
            try {
                XmlStreamWriter writer = WriterFactory.newXmlWriter((File)interpolatedDescriptorFile);
                new DecorationXpp3Writer().write((Writer)writer, decoration);
                this.getLog().debug((CharSequence)("Attaching the site descriptor '" + interpolatedDescriptorFile.getAbsolutePath() + "' with classifier '" + classifier + "' to the project."));
                this.projectHelper.attachArtifact(this.project, "xml", classifier, interpolatedDescriptorFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to store interpolated site descriptor", (Exception)e);
            }
        }
    }
}

