/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.plugins.site.MavenReportExecution;
import org.apache.maven.plugins.site.MavenReportExecutor;
import org.apache.maven.plugins.site.MavenReportExecutorRequest;
import org.apache.maven.plugins.site.ReportPlugin;
import org.apache.maven.plugins.site.ReportSet;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.mortbay.log.Log;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.util.filter.ExclusionsDependencyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=MavenReportExecutor.class)
public class DefaultMavenReportExecutor
implements MavenReportExecutor {
    @Requirement
    private Logger logger;
    @Requirement
    protected MavenPluginManager mavenPluginManager;
    @Requirement
    protected LifecycleExecutor lifecycleExecutor;
    @Requirement
    protected PluginVersionResolver pluginVersionResolver;
    private static final List<String> IMPORTS = Arrays.asList("org.apache.maven.reporting.MavenReport", "org.apache.maven.reporting.MavenMultiPageReport", "org.apache.maven.doxia.siterenderer.Renderer", "org.apache.maven.doxia.sink.SinkFactory", "org.codehaus.doxia.sink.Sink", "org.apache.maven.doxia.sink.Sink", "org.apache.maven.doxia.sink.SinkEventAttributes");
    private static final Set<String> EXCLUDES = new HashSet<String>(Arrays.asList("doxia-site-renderer", "doxia-sink-api"));

    @Override
    public List<MavenReportExecution> buildMavenReports(MavenReportExecutorRequest mavenReportExecutorRequest) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("DefaultMavenReportExecutor.buildMavenReports()");
        }
        ExclusionsDependencyFilter exclusionSetFilter = new ExclusionsDependencyFilter(EXCLUDES);
        DefaultRepositoryRequest repositoryRequest = new DefaultRepositoryRequest();
        repositoryRequest.setLocalRepository(mavenReportExecutorRequest.getLocalRepository());
        repositoryRequest.setRemoteRepositories(mavenReportExecutorRequest.getProject().getPluginArtifactRepositories());
        MavenSession session = mavenReportExecutorRequest.getMavenSession();
        try {
            ArrayList<MavenReportExecution> reports = new ArrayList<MavenReportExecution>();
            for (ReportPlugin reportPlugin : mavenReportExecutorRequest.getReportPlugins()) {
                Plugin plugin = new Plugin();
                plugin.setGroupId(reportPlugin.getGroupId());
                plugin.setArtifactId(reportPlugin.getArtifactId());
                plugin.setVersion(this.getPluginVersion(reportPlugin, (RepositoryRequest)repositoryRequest, mavenReportExecutorRequest));
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("configuring report plugin " + plugin.getId());
                }
                HashSet<String> goals = new HashSet<String>();
                List remoteRepositories = session.getCurrentProject().getRemotePluginRepositories();
                PluginDescriptor pluginDescriptor = this.mavenPluginManager.getPluginDescriptor(plugin, remoteRepositories, session.getRepositorySession());
                if (reportPlugin.getReportSets().isEmpty() && reportPlugin.getReports().isEmpty()) {
                    List mojoDescriptors = pluginDescriptor.getMojos();
                    for (MojoDescriptor mojoDescriptor : mojoDescriptors) {
                        goals.add(mojoDescriptor.getGoal());
                    }
                } else {
                    if (reportPlugin.getReportSets() != null) {
                        for (ReportSet reportSet : reportPlugin.getReportSets()) {
                            goals.addAll(reportSet.getReports());
                        }
                    }
                    if (!reportPlugin.getReports().isEmpty()) {
                        goals.addAll(reportPlugin.getReports());
                    }
                }
                for (String goal : goals) {
                    MojoDescriptor mojoDescriptor;
                    mojoDescriptor = pluginDescriptor.getMojo(goal);
                    if (mojoDescriptor == null) {
                        throw new MojoNotFoundException(goal, pluginDescriptor);
                    }
                    MojoExecution mojoExecution = new MojoExecution(plugin, goal, "report:" + goal);
                    mojoExecution.setConfiguration(this.convert(mojoDescriptor));
                    if (reportPlugin.getConfiguration() != null) {
                        Xpp3Dom reportConfiguration = this.convert(reportPlugin.getConfiguration());
                        Xpp3Dom mergedConfiguration = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)reportConfiguration, (Xpp3Dom)this.convert(mojoDescriptor));
                        Xpp3Dom cleanedConfiguration = new Xpp3Dom("configuration");
                        if (mergedConfiguration.getChildren() != null) {
                            for (Xpp3Dom parameter : mergedConfiguration.getChildren()) {
                                if (!mojoDescriptor.getParameterMap().containsKey(parameter.getName())) continue;
                                cleanedConfiguration.addChild(parameter);
                            }
                        }
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug("mojoExecution mergedConfiguration: " + mergedConfiguration);
                            this.getLog().debug("mojoExecution cleanedConfiguration: " + cleanedConfiguration);
                        }
                        mojoExecution.setConfiguration(cleanedConfiguration);
                    }
                    mojoExecution.setMojoDescriptor(mojoDescriptor);
                    this.mavenPluginManager.setupPluginRealm(pluginDescriptor, mavenReportExecutorRequest.getMavenSession(), Thread.currentThread().getContextClassLoader(), IMPORTS, (DependencyFilter)exclusionSetFilter);
                    MavenReport mavenReport = this.getConfiguredMavenReport(mojoExecution, pluginDescriptor, mavenReportExecutorRequest);
                    if (mavenReport == null) continue;
                    MavenReportExecution mavenReportExecution = new MavenReportExecution(mojoExecution.getPlugin(), mavenReport, (ClassLoader)pluginDescriptor.getClassRealm());
                    this.lifecycleExecutor.calculateForkedExecutions(mojoExecution, mavenReportExecutorRequest.getMavenSession());
                    if (!mojoExecution.getForkedExecutions().isEmpty()) {
                        this.lifecycleExecutor.executeForkedExecutions(mojoExecution, mavenReportExecutorRequest.getMavenSession());
                    }
                    if (!this.canGenerateReport(mavenReport)) continue;
                    reports.add(mavenReportExecution);
                }
            }
            return reports;
        }
        catch (Exception e) {
            throw new MojoExecutionException("failed to get Reports ", e);
        }
    }

    private boolean canGenerateReport(MavenReport mavenReport) {
        try {
            return mavenReport.canGenerateReport();
        }
        catch (AbstractMethodError e) {
            this.getLog().warn("Error loading report " + mavenReport.getClass().getName() + " - AbstractMethodError: canGenerateReport()");
            return true;
        }
    }

    private MavenReport getConfiguredMavenReport(MojoExecution mojoExecution, PluginDescriptor pluginDescriptor, MavenReportExecutorRequest mavenReportExecutorRequest) throws PluginContainerException, PluginConfigurationException {
        try {
            Mojo mojo = (Mojo)this.mavenPluginManager.getConfiguredMojo(Mojo.class, mavenReportExecutorRequest.getMavenSession(), mojoExecution);
            if (!this.isMavenReport(mojoExecution, pluginDescriptor, mojo)) {
                return null;
            }
            return (MavenReport)mojo;
        }
        catch (ClassCastException e) {
            this.getLog().warn("skip ClassCastException " + e.getMessage());
            return null;
        }
        catch (PluginContainerException e) {
            if (e.getCause() != null && e.getCause() instanceof NoClassDefFoundError && e.getMessage().contains("PluginRegistry")) {
                this.getLog().warn("skip NoClassDefFoundError with PluginRegistry ");
                if (this.getLog().isDebugEnabled()) {
                    Log.debug((String)e.getMessage(), (Object)((Object)e));
                }
                return null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMavenReport(MojoExecution mojoExecution, PluginDescriptor pluginDescriptor, Mojo mojo) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoExecution.getGoal());
            Thread.currentThread().setContextClassLoader((ClassLoader)mojoDescriptor.getRealm());
            boolean isMavenReport = MavenReport.class.isAssignableFrom(mojo.getClass());
            if (this.getLog().isDebugEnabled()) {
                if (mojoDescriptor != null && mojoDescriptor.getImplementationClass() != null) {
                    this.getLog().debug("class " + mojoDescriptor.getImplementationClass().getName() + " isMavenReport: " + isMavenReport);
                }
                if (!isMavenReport) {
                    this.getLog().debug("skip non MavenReport " + mojoExecution.getMojoDescriptor().getId());
                }
            }
            boolean bl = isMavenReport;
            return bl;
        }
        catch (LinkageError e) {
            this.getLog().warn("skip LinkageError mojoExecution.goal : " + mojoExecution.getGoal() + " : " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private Xpp3Dom convert(MojoDescriptor mojoDescriptor) {
        PlexusConfiguration config = mojoDescriptor.getMojoConfiguration();
        return config != null ? this.convert(config) : new Xpp3Dom("configuration");
    }

    private Xpp3Dom convert(PlexusConfiguration config) {
        if (config == null) {
            return null;
        }
        Xpp3Dom dom = new Xpp3Dom(config.getName());
        dom.setValue(config.getValue(null));
        for (String attrib : config.getAttributeNames()) {
            dom.setAttribute(attrib, config.getAttribute(attrib, null));
        }
        int n = config.getChildCount();
        for (int i = 0; i < n; ++i) {
            dom.addChild(this.convert(config.getChild(i)));
        }
        return dom;
    }

    private Logger getLog() {
        return this.logger;
    }

    protected String getPluginVersion(ReportPlugin reportPlugin, RepositoryRequest repositoryRequest, MavenReportExecutorRequest mavenReportExecutorRequest) throws PluginVersionResolutionException {
        Plugin plugin;
        String reportPluginKey = null;
        if (this.getLog().isDebugEnabled()) {
            reportPluginKey = reportPlugin.getGroupId() + ':' + reportPlugin.getArtifactId();
            this.getLog().debug("resolving version for " + reportPluginKey);
        }
        if (reportPlugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the reporting.plugins section: " + reportPlugin.getVersion());
            }
            return reportPlugin.getVersion();
        }
        MavenProject project = mavenReportExecutorRequest.getProject();
        if (project.getBuild() != null && (plugin = this.find(reportPlugin, project.getBuild().getPlugins())) != null && plugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the build.plugins section: " + plugin.getVersion());
            }
            return plugin.getVersion();
        }
        if (project.getBuild() != null && project.getBuild().getPluginManagement() != null && (plugin = this.find(reportPlugin, project.getBuild().getPluginManagement().getPlugins())) != null && plugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the build.pluginManagement.plugins section: " + plugin.getVersion());
            }
            return plugin.getVersion();
        }
        this.logger.warn("Report plugin " + reportPluginKey + " has an empty version.");
        this.logger.warn("");
        this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
        this.logger.warn("");
        this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
        plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        DefaultPluginVersionRequest pluginVersionRequest = new DefaultPluginVersionRequest(plugin, mavenReportExecutorRequest.getMavenSession());
        pluginVersionRequest.setGroupId(reportPlugin.getGroupId());
        pluginVersionRequest.setArtifactId(reportPlugin.getArtifactId());
        PluginVersionResult result = this.pluginVersionResolver.resolve((PluginVersionRequest)pluginVersionRequest);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("resolved " + reportPluginKey + " version from repository: " + result.getVersion());
        }
        return result.getVersion();
    }

    private Plugin find(ReportPlugin reportPlugin, List<Plugin> plugins) {
        if (plugins == null) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!StringUtils.equals((String)plugin.getArtifactId(), (String)reportPlugin.getArtifactId()) || !StringUtils.equals((String)plugin.getGroupId(), (String)reportPlugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }
}

