/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractProjectInfoRenderer
extends AbstractMavenReportRenderer {
    private I18N i18n;
    private Locale locale;

    public AbstractProjectInfoRenderer(Sink sink, I18N i18n, Locale locale) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
    }

    public String getTitle() {
        return this.getI18nString("title");
    }

    protected String getI18nString(String key) {
        return this.getI18nString(this.getI18Nsection(), key);
    }

    protected String getI18nString(String section, String key) {
        return this.i18n.getString("project-info-report", this.locale, "report." + section + '.' + key);
    }

    protected void text(String text) {
        if (StringUtils.isEmpty((String)text)) {
            this.sink.text("-");
        } else {
            String regex = "(.+?)<(\"[^\"]*\"|'[^']*'|[^'\">])*>(.+?)";
            if (Pattern.matches(regex, text)) {
                this.sink.rawText(text);
            } else {
                this.sink.text(text);
            }
        }
    }

    protected abstract String getI18Nsection();
}

