/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

@Deprecated
public class Freq {
    public static Freq INFINITE = new Freq(0.0, FreqUnits.SECONDS);
    private FreqUnits units;
    private double ammount;

    public static int compare(long freq1, long freq2) {
        if (freq1 < freq2) {
            return -1;
        }
        if (freq1 == freq2) {
            return 0;
        }
        return 1;
    }

    public static int compare(Freq freq1, Freq freq2) {
        return Freq.compare(freq1.tick(), freq2.tick());
    }

    Freq() {
        this.ammount = 0.0;
        this.units = FreqUnits.NONE;
    }

    Freq(double count, FreqUnits units) {
        this.ammount = count;
        this.units = units;
    }

    public Freq(Freq original) {
        this.ammount = original.ammount;
        this.units = original.units;
    }

    public String toString() {
        if (!FreqUnits.NONE.equals((Object)this.units)) {
            return "(" + (Object)((Object)this.getUnits()) + " " + this.getAmmount() + ")";
        }
        return "";
    }

    public FreqUnits getUnits() {
        return this.units;
    }

    public void setUnits(FreqUnits units) {
        this.units = units;
    }

    public double getAmmount() {
        return this.ammount;
    }

    public void setAmmount(double ammount) {
        this.ammount = ammount;
    }

    public long tick() {
        switch (this.units) {
            case HOURS: {
                return (long)(3600000.0 * this.ammount);
            }
            case MINUTES: {
                return (long)(60000.0 * this.ammount);
            }
            case SECONDS: {
                return (long)(1000.0 * this.ammount);
            }
            case HZ: {
                return (long)(1000.0 / this.ammount);
            }
            case PM: {
                return (long)(60000.0 / this.ammount);
            }
            case NONE: {
                return (long)this.ammount;
            }
        }
        throw new IllegalStateException("Invalid units.");
    }

    public static enum FreqUnits {
        HOURS("hours", 0),
        MINUTES("minutes", 1),
        SECONDS("seconds", 2),
        NONE("none", 3),
        HZ("hz", 4),
        PM("pm", 5);

        private final String name;
        private final int id;

        private FreqUnits(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public String toString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

