/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class PrimitiveData
implements Comparable<PrimitiveData> {
    public final String classFQN;
    public final String name;
    public final String description;
    public final String[] tags;
    public final Set<ParamInfo> params;

    public PrimitiveData(String classFQN) {
        this(classFQN, null, null, new String[0], Collections.emptySet());
    }

    public PrimitiveData(String classFQN, String name, String description, String[] tags, Set<ParamInfo> parameters) {
        this.classFQN = classFQN;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.params = Collections.unmodifiableSet(new HashSet<ParamInfo>(parameters));
    }

    public String getClassName() {
        return this.classFQN.replaceFirst("^.*\\.", "");
    }

    @Override
    public int compareTo(PrimitiveData o) {
        if (this == o) {
            return 0;
        }
        String myName = this.name != null ? this.name : this.getClassName();
        String oName = o.name != null ? o.name : o.getClassName();
        int nameComparison = myName.toLowerCase().compareTo(oName.toLowerCase());
        if (nameComparison != 0) {
            return nameComparison;
        }
        return this.classFQN.compareTo(o.classFQN);
    }

    public String toString() {
        return (this.name != null ? this.name : this.getClassName()) + "(" + this.classFQN + ")";
    }

    public String getHtmlDescription() {
        StringBuilder info = new StringBuilder();
        info.append("<html><b>Class:</b> ");
        info.append(this.classFQN);
        if (this.name != null) {
            info.append("<br/><b>Name:</b> ");
            info.append(this.name);
        }
        if (this.description != null) {
            info.append("<br/><b>Description:</b> ");
            info.append(this.description);
        }
        if (this.tags.length > 0) {
            info.append("<br/><b>Tags:</b> ");
            for (int tagIndex = 0; tagIndex < this.tags.length; ++tagIndex) {
                info.append(this.tags[tagIndex]);
                if (tagIndex == this.tags.length - 1) continue;
                info.append(',');
                info.append(' ');
            }
        }
        info.append("</html>");
        return info.toString();
    }
}

