/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite.rewriter;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@XStreamAlias(value="substitution")
public class Substitution {
    @XStreamAlias(value="match")
    private String reMatch;
    @XStreamAlias(value="replace")
    private String reSubst;
    @XStreamAlias(value="caseSensitive")
    private Boolean caseSensitive;
    @XStreamOmitField
    private transient Pattern pattern;

    public Substitution() {
    }

    public Substitution(String reMatch, String reSubst, boolean caseSensitive) {
        this.reMatch = reMatch;
        this.reSubst = reSubst;
        this.caseSensitive = caseSensitive;
    }

    private Substitution readResolve() {
        if (this.caseSensitive == null) {
            this.caseSensitive = true;
        }
        return this;
    }

    public String getReMatch() {
        return this.reMatch;
    }

    public void setReMatch(String reMatch) {
        this.reMatch = reMatch;
        this.pattern = null;
    }

    public String getReSubst() {
        return this.reSubst;
    }

    public void setReSubst(String reSubst) {
        this.reSubst = reSubst;
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.reMatch, this.caseSensitive != false ? 0 : 2);
        }
        return this.pattern;
    }

    public Matcher getMatcher(String str) {
        return this.getPattern().matcher(str);
    }

    public String substitute(String str) {
        return this.getMatcher(str).replaceAll(this.reSubst);
    }

    public String toString() {
        return "Substitution[" + (this.caseSensitive != false ? "case-sensitive" : "case-INsensitive") + ", " + this.reMatch + " --> " + this.reSubst + "]";
    }
}

