/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite.rewriter;

import cz.cuni.amis.utils.rewrite.rewriter.Const;
import cz.cuni.amis.utils.rewrite.rewriter.Substitution;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class Rewriter {
    private List<Substitution> substitutions;
    private Logger log = null;

    public Rewriter() {
        this.substitutions = new ArrayList<Substitution>();
    }

    public Rewriter(List<Substitution> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException("'substitutions' can't be null!");
        }
        this.substitutions = substitutions;
    }

    public Logger getLog() {
        return this.log;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public List<Substitution> getSubstitutions() {
        return this.substitutions;
    }

    public Rewriter addSubstitution(Substitution subst) {
        if (subst == null) {
            return this;
        }
        this.substitutions.add(subst);
        return this;
    }

    public synchronized String rewrite(String text) {
        if (this.substitutions.size() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        String result = text;
        for (Substitution subst : this.substitutions) {
            result = subst.substitute(result);
        }
        return result;
    }

    public synchronized boolean rewriteFile(File input, File output) throws IOException {
        int lineNumber = 1;
        boolean changed = false;
        BufferedReader reader = new BufferedReader(new FileReader(input));
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(output));
            try {
                while (reader.ready()) {
                    String rewritten;
                    String line = reader.readLine();
                    if (!line.equals(rewritten = this.rewrite(line))) {
                        changed = true;
                        if (this.log != null) {
                            this.log.info("Replacing[" + lineNumber + "]" + ": " + line.trim() + Const.NEW_LINE + "       With:        " + Const.whitespaces(String.valueOf(lineNumber).length()) + rewritten.trim());
                        }
                    }
                    writer.println(rewritten);
                    ++lineNumber;
                }
            }
            finally {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
        return changed;
    }

    public synchronized boolean rewriteFile(File file) throws IOException {
        File tempFile = new File("temp.rewrite.txt");
        if (this.rewriteFile(file, tempFile)) {
            file.delete();
            FileUtils.moveFile((File)tempFile, (File)file);
            tempFile.delete();
            return true;
        }
        tempFile.delete();
        return false;
    }
}

