package cz.cuni.amis.utils.rewrite.rewriter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.apache.commons.io.FileUtils;


public class Rewriter {
	
	private List<Substitution> substitutions;
	
	private Logger log = null;

	public Rewriter() {
		substitutions = new ArrayList<Substitution>();
	}
	
	public Rewriter(List<Substitution> substitutions) {
		if (substitutions == null) throw new IllegalArgumentException("'substitutions' can't be null!");
		this.substitutions = substitutions;
	}
	
	public Logger getLog() {
		return log;
	}

	public void setLog(Logger log) {
		this.log = log;
	}

	public List<Substitution> getSubstitutions() {
		return substitutions;
	}

	public Rewriter addSubstitution(Substitution subst) {
		if (subst == null) return this;
		this.substitutions.add(subst);
		return this;
	}
	
	public synchronized String rewrite(String text) {
		if (substitutions.size() == 0) return text;
		if (text == null) return null;
		String result = text;
		for (Substitution subst : substitutions) {
			result = subst.substitute(result);
		}		
		return result;
	}
	
	public synchronized boolean rewriteFile(File input, File output) throws IOException {
		int lineNumber = 1;
		
		boolean changed = false;
		
		BufferedReader reader = new BufferedReader(new FileReader(input));
		try {
			PrintWriter writer = new PrintWriter(new FileWriter(output));
			try {
				while (reader.ready()) {
					String line = reader.readLine();
					String rewritten = rewrite(line);
					
					if (!line.equals(rewritten)) {
						changed = true;
						if (log != null) {
							log.info(       "Replacing" + "[" + lineNumber + "]" + ": " + line.trim() + Const.NEW_LINE 
									+ "       With:        " + Const.whitespaces(String.valueOf(lineNumber).length()) + rewritten.trim());
						}
					}
					
					writer.println(rewritten);
					++lineNumber;
				}
			} finally {
				writer.close();
			}
		} finally {
			reader.close();
		}
		
		return changed;
	}
	
	public synchronized boolean rewriteFile(File file) throws IOException {
		File tempFile = new File("temp.rewrite.txt");
		if (rewriteFile(file, tempFile)) {
			// file was changed
			file.delete();
			FileUtils.moveFile(tempFile, file);
			tempFile.delete();
			return true;
		} else {
			// no changes
			tempFile.delete();
			return false;
		}
	}
	
}
