/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.process;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="jarProcess")
public class JarExecutionConfig
extends ProcessExecutionConfig {
    @XStreamAlias(value="jar")
    private String jar;
    @XStreamImplicit(itemFieldName="javaArg")
    private List<String> javaArgs;

    public JarExecutionConfig() {
        this(System.getenv("JAVA_HOME"));
    }

    public JarExecutionConfig(String javaHome) {
        if (javaHome != null && javaHome.trim().length() == 0) {
            javaHome = null;
        }
        boolean linux = System.getProperty("os.name").toLowerCase().contains("linux");
        boolean mac = System.getProperty("os.name").contains("Mac");
        String command = javaHome == null ? (linux || mac ? "java" : "java.exe") : javaHome + (linux || mac ? "/bin/java" : "\\bin\\java.exe");
        this.setPathToProgram(command);
    }

    public List<String> getJavaArgs() {
        return this.javaArgs;
    }

    public JarExecutionConfig addJavaArg(String arg) {
        if (this.javaArgs == null) {
            this.javaArgs = new ArrayList<String>();
        }
        this.javaArgs.add(arg);
        return this;
    }

    public JarExecutionConfig setJavaArgs(List<String> args) {
        this.javaArgs = args;
        return this;
    }

    public String getJar() {
        return this.jar;
    }

    public JarExecutionConfig setJar(String jar) {
        this.jar = jar;
        return this;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("JarExecutionConfig[");
        sb.append(Const.NEW_LINE + "  pathToProgram     = " + this.getPathToProgram());
        sb.append(Const.NEW_LINE + "  executionDir      = " + this.getExecutionDir());
        sb.append(Const.NEW_LINE + "  args              = ");
        if (this.getArgs() != null) {
            for (String arg : this.getArgs()) {
                sb.append(Const.NEW_LINE + "    " + arg);
            }
        }
        sb.append(Const.NEW_LINE + "  javaArgs          = ");
        if (this.getJavaArgs() != null) {
            for (String arg : this.getJavaArgs()) {
                sb.append(Const.NEW_LINE + "    " + arg);
            }
        }
        sb.append(Const.NEW_LINE + "  redirectStdOut   = " + this.isRedirectStdOut());
        sb.append(Const.NEW_LINE + "  redirectStdErr   = " + this.isRedirectStdErr());
        sb.append("]");
        return sb.toString();
    }
}

