/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.process;

import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.StreamSink;
import cz.cuni.amis.utils.Tuple3;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessExecution {
    protected ProcessExecutionConfig config;
    protected Flag<Boolean> running = new Flag((Object)false);
    protected Process process = null;
    protected StreamSink streamSinkOutput = null;
    protected StreamSink streamSinkError = null;
    protected Logger log;
    protected Runnable shutDownHook = new Runnable(){

        @Override
        public void run() {
            if (ProcessExecution.this.process != null) {
                ProcessExecution.this.process.destroy();
            }
        }
    };
    protected Thread shutDownHookThread;
    protected boolean timedout = false;
    protected Runnable waitForEnd = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            boolean terminated;
            long start = System.currentTimeMillis();
            long timeout = ProcessExecution.this.config.getTimeout() == null ? -1L : ProcessExecution.this.config.getTimeout();
            try {
                if (timeout <= 0L) {
                    ProcessExecution.this.process.waitFor();
                    return;
                }
                terminated = false;
            }
            catch (InterruptedException e) {
                Flag<Boolean> flag = ProcessExecution.this.running;
                synchronized (flag) {
                    if (!((Boolean)ProcessExecution.this.running.getFlag()).booleanValue()) {
                        return;
                    }
                }
                if (ProcessExecution.this.log == null) return;
                if (!ProcessExecution.this.log.isLoggable(Level.WARNING)) return;
                ProcessExecution.this.log.warning("Interrupted while waiting for the process(" + ProcessExecution.this.config.getId() + ") to end!");
                return;
            }
            finally {
                Flag<Boolean> flag = ProcessExecution.this.running;
                synchronized (flag) {
                    if (!((Boolean)ProcessExecution.this.running.getFlag()).booleanValue()) {
                        return;
                    }
                    if (ProcessExecution.this.waitForEndThread == Thread.currentThread()) {
                        ProcessExecution.this.shutdown(true);
                    }
                }
            }
            while (System.currentTimeMillis() - start < timeout) {
                try {
                    ProcessExecution.this.process.exitValue();
                    terminated = true;
                }
                catch (Exception e) {
                    terminated = false;
                }
                if (terminated) break;
                long waitMillis = Math.min(500L, 100L + timeout - (System.currentTimeMillis() - start));
                Thread.sleep(waitMillis);
            }
            if (terminated) return;
            Flag<Boolean> flag = ProcessExecution.this.running;
            synchronized (flag) {
                if (ProcessExecution.this.waitForEndThread != Thread.currentThread()) return;
                ProcessExecution.this.timedout = true;
                if (ProcessExecution.this.log != null && ProcessExecution.this.log.isLoggable(Level.SEVERE)) {
                    ProcessExecution.this.log.severe("Process(" + ProcessExecution.this.config.getId() + ") TIMEOUT!");
                }
                ProcessExecution.this.shutdown(true);
                return;
            }
        }
    };
    protected Thread waitForEndThread;
    private Integer lastExitValue = null;
    public static final Pattern SIMPLE_PARAM = Pattern.compile("\\$([a-zA-Z0-9_]+)");
    public static final Pattern FORMAL_PARAM = Pattern.compile("\\$\\{(.+)\\}");

    public ProcessExecution(ProcessExecutionConfig config, Logger log) {
        this.log = log;
        this.config = config;
    }

    public static String substituteParams(String command, Logger log) {
        ArrayList<Tuple3> params = new ArrayList<Tuple3>();
        for (int i = 0; i < 2; ++i) {
            Matcher m;
            Matcher matcher = m = i == 0 ? SIMPLE_PARAM.matcher(command) : FORMAL_PARAM.matcher(command);
            while (m.find()) {
                params.add(new Tuple3((Object)m.start(), (Object)m.group().length(), (Object)m.group(1)));
            }
        }
        if (params.size() == 0) {
            return command;
        }
        Collections.sort(params, new Comparator<Tuple3<Integer, Integer, String>>(){

            @Override
            public int compare(Tuple3<Integer, Integer, String> o1, Tuple3<Integer, Integer, String> o2) {
                return (Integer)o2.getFirst() - (Integer)o1.getFirst();
            }
        });
        String result = command;
        if (log != null && log.isLoggable(Level.INFO)) {
            log.info("Substituing parameters for: " + command);
        }
        for (Tuple3 param : params) {
            String paramValue = System.getenv((String)param.getThird());
            if (paramValue == null) {
                paramValue = System.getProperty((String)param.getThird());
            }
            if (paramValue == null) {
                if (log != null && log.isLoggable(Level.WARNING)) {
                    log.warning("Parameter '" + (String)param.getThird() + "' not found! Both System.getenv(\"" + (String)param.getThird() + "\") and System.getProperty(\"" + (String)param.getThird() + "\") evaluates to null!");
                }
                return null;
            }
            result = result.substring(0, (Integer)param.getFirst()) + paramValue + result.substring((Integer)param.getFirst() + (Integer)param.getSecond());
        }
        if (log != null && log.isLoggable(Level.INFO)) {
            log.info("Substitution result: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws PogamutIOException {
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            if (((Boolean)this.running.getFlag()).booleanValue()) {
                throw new PogamutException("Could not start the process again, it is already running! stop() it first!", this.log, (Object)this);
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Starting process with config: " + Const.NEW_LINE + this.config);
            }
            if (this.config.getPathToProgram() == null) {
                throw new PogamutException("Could not start the process according to config " + this.config + " as the path to program was not specified (is null).", (Object)this);
            }
            List<String> commandParts = this.getCommandParts();
            String fullCommand = this.config.getPathToProgram();
            for (int i = 0; i < commandParts.size(); ++i) {
                String part = ProcessExecution.substituteParams(commandParts.get(i), this.log);
                if (part == null) {
                    throw new PogamutException("Could not substitute one of the command paramters, FAILURE!", this.log, (Object)this);
                }
                commandParts.set(i, part);
                fullCommand = i == 0 ? part : fullCommand + " " + part;
            }
            File directory = this.config.getExecutionDir() != null ? new File(this.config.getExecutionDir()) : (new File(this.config.getPathToProgram()).getParentFile() != null ? new File(this.config.getPathToProgram()).getParentFile() : new File("."));
            if (this.log != null && this.log.isLoggable(Level.INFO)) {
                this.log.info("Executing command: " + fullCommand);
                this.log.info("Base directory:    " + directory.getAbsolutePath());
            }
            ProcessBuilder procBuilder = new ProcessBuilder(commandParts.toArray(new String[commandParts.size()]));
            procBuilder.directory(directory);
            try {
                this.timedout = false;
                this.lastExitValue = null;
                this.process = procBuilder.start();
            }
            catch (IOException e) {
                if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                    this.log.severe("Could not start the process: " + e.getMessage());
                }
                this.process = null;
                throw new PogamutIOException("Failed to start the process(" + this.config.getId() + "). IOException: " + e.getMessage(), (Throwable)e, (Object)this);
            }
            this.streamSinkError = this.config.isRedirectStdErr() ? new StreamSink(this.config.getId() + "-StdErrSink", this.process.getErrorStream(), this.log, this.config.getId() + "-StdErr") : new StreamSink(this.config.getId() + "-StdErrSink", this.process.getErrorStream());
            this.streamSinkError.start();
            this.streamSinkOutput = this.config.isRedirectStdOut() ? new StreamSink(this.config.getId() + "-StdOutSink", this.process.getInputStream(), this.log, this.config.getId() + "-StdOut") : new StreamSink(this.config.getId() + "-StdOutSink", this.process.getInputStream());
            this.streamSinkOutput.start();
            this.shutDownHookThread = new Thread(this.shutDownHook, this.config.getId() + "-JVMShutdownHook");
            Runtime.getRuntime().addShutdownHook(this.shutDownHookThread);
            this.waitForEndThread = new Thread(this.waitForEnd, this.config.getId() + "-WaitForProcessEnd");
            this.running.setFlag((Object)true);
            this.waitForEndThread.start();
        }
    }

    protected List<String> getCommandParts() {
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add(this.config.getPathToProgram());
        if (this.config.getArgs() != null) {
            for (String arg : this.config.getArgs()) {
                commandParts.add(arg);
            }
        }
        return commandParts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(boolean waitForEndThread) {
        Process p = this.process;
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            if (!((Boolean)this.running.getFlag()).booleanValue()) {
                return;
            }
            if (this.process != p) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Shutting down process(" + this.config.getId() + ")!");
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying process(" + this.config.getId() + ").");
            }
            try {
                this.lastExitValue = this.process.exitValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.process != null) {
                try {
                    this.process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.process = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying streamSinkError(" + this.config.getId() + ").");
            }
            try {
                if (this.streamSinkError != null) {
                    this.streamSinkError.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamSinkError = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying streamSinkOutput(" + this.config.getId() + ").");
            }
            try {
                if (this.streamSinkOutput != null) {
                    this.streamSinkOutput.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamSinkOutput = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... destroying waitForEnd(" + this.config.getId() + ").");
            }
            if (!waitForEndThread) {
                try {
                    if (this.waitForEndThread != null) {
                        this.waitForEndThread.interrupt();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.waitForEndThread = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... removing shutDownHook(" + this.config.getId() + ").");
            }
            if (this.shutDownHookThread != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.shutDownHookThread);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.shutDownHookThread = null;
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("... setting running-flag(" + this.config.getId() + ") to FALSE.");
            }
            this.running.setFlag((Object)false);
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Shutdown(" + this.config.getId() + ") finished.");
            }
        }
    }

    public void stop() {
        this.shutdown(false);
    }

    public Process getBotProcess() {
        return this.process;
    }

    public ImmutableFlag<Boolean> getRunning() {
        return this.running.getImmutable();
    }

    public boolean isRunning() {
        return (Boolean)this.running.getFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getExitValue() {
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            return this.lastExitValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTimeout() {
        Flag<Boolean> flag = this.running;
        synchronized (flag) {
            return this.timedout;
        }
    }

    public boolean isFailed(boolean report) {
        if (this.isTimeout() || this.getExitValue() == null || this.getExitValue() != 0) {
            if (report && this.log != null && this.log.isLoggable(Level.WARNING)) {
                if (this.isTimeout()) {
                    this.log.warning("Process TIMED OUT!");
                } else if (this.getExitValue() == null) {
                    this.log.warning("Process FAILED to return exit value!");
                } else {
                    this.log.warning("Process EXIT VALUE is " + this.getExitValue() + " != 0!");
                }
            }
            return true;
        }
        if (report && this.log != null && this.log.isLoggable(Level.INFO)) {
            if (this.isRunning()) {
                this.log.info("Process is still running.");
            } else {
                this.log.info("Process has finished OK.");
            }
        }
        return false;
    }

    public boolean isFailed() {
        return this.isFailed(false);
    }
}

