/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.eh4j;

import cz.cuni.amis.utils.eh4j.AsEnumClass;
import cz.cuni.amis.utils.eh4j.EnumObject;
import cz.cuni.amis.utils.eh4j.Enums;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EnumType {
    private String name;
    private Class enumClass;
    private AsEnumClass enumClassAnnot;
    private Map<String, EnumObject> allEnumObjects = new HashMap<String, EnumObject>();
    private Map<String, EnumObject> ownEnumObjects = new HashMap<String, EnumObject>();
    private Map<String, Object> allEnums = new HashMap<String, Object>();
    private Map<String, Object> ownEnums = new HashMap<String, Object>();
    private Map<EnumObject, EnumType> enum2ChildClass = new HashMap<EnumObject, EnumType>();
    private Map<EnumType, EnumObject> childClass2Enum = new HashMap<EnumType, EnumObject>();
    private Map<EnumObject, EnumType> enum2ParentClass = new HashMap<EnumObject, EnumType>();
    private Map<EnumType, EnumObject> parentClass2Enum = new HashMap<EnumType, EnumObject>();
    private Map<EnumObject, EnumType> enum2ParentClassAll = new HashMap<EnumObject, EnumType>();
    private Map<EnumType, EnumObject> parentClass2EnumAll = new HashMap<EnumType, EnumObject>();
    private Map<Class, EnumType> extending = new HashMap<Class, EnumType>();

    public EnumType(Class enumClass) {
        this.enumClass = enumClass;
        this.enumClassAnnot = enumClass.getAnnotation(AsEnumClass.class);
        this.name = this.enumClassAnnot == null || this.enumClassAnnot.name().length() == 0 ? enumClass.getSimpleName() : this.enumClassAnnot.name();
    }

    public String getName() {
        return this.name;
    }

    public Collection<Object> enums() {
        return this.ownEnums.values();
    }

    public <T> Collection<T> enums(Class<T> type) {
        return this.ownEnums.values();
    }

    public Object getEnum(String name) {
        return this.ownEnums.get(name);
    }

    public Collection<Object> enumsAll() {
        return this.allEnums.values();
    }

    public <T> Collection<? extends T> enumsAll(Class<T> type) {
        return this.allEnums.values();
    }

    public Object getEnumAny(String name) {
        return this.allEnums.get(name);
    }

    public Collection<EnumObject> enumObjects() {
        return this.ownEnumObjects.values();
    }

    public EnumObject enumObject(String name) {
        return this.ownEnumObjects.get(name);
    }

    public Collection<EnumObject> enumObjectsAll() {
        return this.allEnumObjects.values();
    }

    public EnumObject enumObjectAny(String name) {
        return this.allEnumObjects.get(name);
    }

    protected EnumObject findParentOf(EnumType enumType) {
        if (this == enumType) {
            return null;
        }
        EnumObject result = this.parentClass2EnumAll.get(enumType);
        if (result != null) {
            return result;
        }
        result = this.parentClass2Enum.get(enumType);
        if (result != null) {
            this.parentClass2EnumAll.put(enumType, result);
            return result;
        }
        for (EnumType parentType : this.parentClass2Enum.keySet()) {
            result = parentType.findParentOf(enumType);
            if (result == null) continue;
            this.parentClass2EnumAll.put(enumType, result);
            return result;
        }
        return null;
    }

    protected EnumObject findParentOf(Class enumClass) {
        EnumType enumType = Enums.getInstance().getEnumType(enumClass);
        return this.findParentOf(enumType);
    }

    public boolean isExactly(Class enumClass) {
        if (enumClass == null) {
            return false;
        }
        return enumClass == this.enumClass;
    }

    public boolean isExactly(EnumType enumType) {
        if (enumType == null) {
            return false;
        }
        return this == enumType;
    }

    public boolean isA(Class enumClass) {
        if (enumClass == null) {
            return false;
        }
        if (enumClass == this.enumClass) {
            return true;
        }
        EnumType enumType = Enums.getInstance().getEnumType(enumClass);
        this.findParentOf(enumType);
        return this.parentClass2EnumAll.containsKey(enumType);
    }

    public boolean isA(EnumType enumType) {
        if (enumType == null) {
            return false;
        }
        if (this == enumType) {
            return true;
        }
        this.findParentOf(enumType);
        return this.parentClass2EnumAll.containsKey(enumType);
    }

    public boolean isA(Object enumInstance) {
        EnumObject enumObject = Enums.getInstance().getEnumObject(enumInstance);
        if (enumObject.type == this) {
            return false;
        }
        return this.isA(enumObject.childType);
    }

    public EnumObject getAs(Class enumClass) {
        EnumType enumType = Enums.getInstance().getEnumType(enumClass);
        if (enumClass == null) {
            return null;
        }
        this.findParentOf(enumType);
        return this.parentClass2EnumAll.get(enumType);
    }

    protected void registerChildEnum(EnumObject enumObject) {
        if (this.allEnumObjects.containsKey(enumObject.name)) {
            if (this.allEnumObjects.get(enumObject.name) == enumObject) {
                return;
            }
            throw new RuntimeException("Enum object name clash for '" + enumObject.name + "'! Cannot register " + enumObject + " as there is already registered enum object " + this.allEnumObjects.get(enumObject.name) + ".");
        }
        this.allEnums.put(enumObject.name, enumObject.enumInstance);
        this.allEnumObjects.put(enumObject.name, enumObject);
        for (EnumType parent : this.extending.values()) {
            parent.registerChildEnum(enumObject);
        }
    }

    protected void registerOwnEnum(EnumObject enumObject) {
        if (this.ownEnumObjects.containsValue(enumObject)) {
            return;
        }
        this.registerChildEnum(enumObject);
        this.ownEnums.put(enumObject.name, enumObject.enumInstance);
        this.ownEnumObjects.put(enumObject.name, enumObject);
        this.registerChildClass(enumObject);
    }

    protected void registerChildClass(EnumObject enumObject) {
        this.registerOwnEnum(enumObject);
        if (enumObject.childType == null) {
            return;
        }
        this.enum2ChildClass.put(enumObject, enumObject.childType);
        for (EnumObject obj : enumObject.childType.allEnumObjects.values()) {
            this.registerChildEnum(obj);
        }
        enumObject.childType.registerParentClass(enumObject, this);
    }

    protected void registerParentClass(EnumObject enumObject, EnumType enumParentType) {
        this.enum2ParentClass.put(enumObject, enumParentType);
        this.parentClass2Enum.put(enumParentType, enumObject);
    }

    public String toString() {
        return "EnumType[" + this.getName() + ", #all=" + this.allEnumObjects.size() + ", #own=" + this.ownEnumObjects.size() + "]";
    }
}

