/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.StackElement;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;

class ADExecutor
extends AbstractExecutor
implements ElementExecutor {
    private Adopt adopt;
    private PoshPlan plan;
    private SenseListExecutor<Adopt> exitConditionExecutor;

    protected ADExecutor(PoshPlan plan, Adopt ad, LapPath adoptPath, VariableContext ctx, EngineLog engineLog) {
        super(adoptPath, ctx, engineLog);
        assert (adoptPath.traversePath(plan) == ad);
        this.plan = plan;
        this.adopt = ad;
        this.exitConditionExecutor = new SenseListExecutor<Adopt>(ad.getExitCondition(), adoptPath, ctx, engineLog);
    }

    public boolean isExit(IWorkExecutor workExecutor) {
        return this.exitConditionExecutor.fire(workExecutor, true).wasSuccess();
    }

    public Trigger<Adopt> getExitCondition() {
        return this.adopt.getExitCondition();
    }

    public TriggeredAction getAdoptedElement() {
        return this.adopt.getAdoptedElement();
    }

    @Override
    public FireResult fire(IWorkExecutor workExecuter) {
        this.engineLog.pathReached(this.path);
        if (this.isExit(workExecuter)) {
            return new FireResult(FireResult.Type.SURFACE);
        }
        return new FireResult(FireResult.Type.FOLLOW, this.createActionExecutor());
    }

    private LapPath createAdoptActionPath() {
        return this.path.concat(LapType.ACTION, 0);
    }

    private StackElement createActionExecutor() {
        PrimitiveCall actionCall = this.getAdoptedElement().getActionCall();
        LapPath adoptActionPath = this.createAdoptActionPath();
        return this.getElement(this.plan, actionCall, adoptActionPath);
    }
}

