/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.IAction;
import cz.cuni.amis.pogamut.sposh.executor.ISense;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Logger;

public class StateWorkExecutor
implements IWorkExecutor {
    protected final HashMap<String, IAction> actions = new HashMap();
    protected final HashMap<String, ISense> senses = new HashMap();
    protected String currentActionName;
    protected String currentVariableContext;
    protected Logger log;

    public StateWorkExecutor() {
        this.log = Logger.getLogger(this.getClass().getSimpleName());
    }

    public StateWorkExecutor(Logger log) {
        this.log = log;
    }

    public Logger getLogger() {
        return this.log;
    }

    public synchronized boolean isNameUsed(String name) {
        return this.isSense(name) || this.isAction(name);
    }

    protected boolean isAction(String name) {
        return this.actions.containsKey(name);
    }

    protected boolean isSense(String name) {
        return this.senses.containsKey(name);
    }

    public synchronized void addAction(String name, IAction action) {
        if (this.isNameUsed(name)) {
            throw new IllegalArgumentException("Primtive with name \"" + name + "\" is already present in executor.");
        }
        this.actions.put(name, action);
    }

    public synchronized void addSense(String name, ISense sense) {
        if (this.isNameUsed(name)) {
            throw new IllegalArgumentException("Primtive with name \"" + name + "\" is already present in executor.");
        }
        this.senses.put(name, sense);
    }

    public void addAction(IAction action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addSense(ISense sense) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private String getSenseName(ISense sense, String primitiveName) {
        PrimitiveInfo info = sense.getClass().getAnnotation(PrimitiveInfo.class);
        if (info == null) {
            return primitiveName;
        }
        if (info.name() == null) {
            return primitiveName;
        }
        return info.name();
    }

    private String getActionName(IAction sense, String primitiveName) {
        PrimitiveInfo info = sense.getClass().getAnnotation(PrimitiveInfo.class);
        if (info == null) {
            return primitiveName;
        }
        if (info.name() == null) {
            return primitiveName;
        }
        return info.name();
    }

    @Override
    public synchronized Object executeSense(String primitive, VariableContext ctx) {
        if (!this.isSense(primitive)) {
            throw new IllegalArgumentException("Sense \"" + primitive + "\" is not specified in the worker.");
        }
        ISense current = this.senses.get(primitive);
        Object result = current.query(ctx);
        this.log.info(MessageFormat.format("Query: {0}({1}) = {2}", this.getSenseName(current, primitive), ctx, result));
        return result;
    }

    @Override
    public synchronized ActionResult executeAction(String actionToExecuteName, VariableContext ctx) {
        if (!this.isAction(actionToExecuteName)) {
            throw new IllegalArgumentException("Action \"" + actionToExecuteName + "\" is not specified in the worker.");
        }
        IAction actionToExecute = this.actions.get(actionToExecuteName);
        String variableContextToExecute = ctx.toString();
        IAction currentAction = this.actions.get(this.currentActionName);
        if (currentAction == null) {
            this.currentActionName = actionToExecuteName;
            this.currentVariableContext = ctx.toString();
            currentAction = actionToExecute;
            this.log.info(MessageFormat.format("Action: {0}.init({1})", this.getActionName(currentAction, this.currentActionName), ctx));
            currentAction.init(ctx);
        } else if (currentAction != null && actionToExecute != currentAction || !variableContextToExecute.equals(this.currentVariableContext)) {
            this.log.info(MessageFormat.format("Action: {0}.done({1})", this.getActionName(currentAction, this.currentActionName), ctx));
            currentAction.done(ctx);
            this.currentActionName = actionToExecuteName;
            this.currentVariableContext = variableContextToExecute;
            currentAction = actionToExecute;
            this.log.info(MessageFormat.format("Action: {0}.init({1})", this.getActionName(currentAction, this.currentActionName), ctx));
            currentAction.init(ctx);
        }
        ActionResult result = currentAction.run(ctx);
        this.log.info(MessageFormat.format("Action: {0}.run({1}) = {2}", new Object[]{this.getActionName(currentAction, this.currentActionName), ctx, result}));
        if (result == ActionResult.FINISHED || result == ActionResult.RUNNING_ONCE) {
            this.log.info(MessageFormat.format("Action: {0}.done({1})", this.getActionName(currentAction, this.currentActionName), ctx));
            currentAction.done(ctx);
            currentAction = null;
            this.currentActionName = null;
            this.currentVariableContext = null;
        }
        return result;
    }
}

