/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.CompetenceTest;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.IElementMethod;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.RemoveTest;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DriveCollectionTest {
    private int numDrives = 10;
    private DriveCollection instance;
    private String drivePrefix = "drive-no-";
    private List<DriveElement> drives;

    @Before
    public void setUp() {
        this.instance = LapElementsFactory.createDriveCollection();
        this.drives = new ArrayList<DriveElement>(this.numDrives);
        for (int driveNo = 0; driveNo < this.numDrives; ++driveNo) {
            this.drives.add(LapElementsFactory.createDriveElement((String)(this.drivePrefix + driveNo)));
        }
    }

    @Test
    public void testAddDrive() throws Exception {
        System.out.println("addDrive");
        for (DriveElement drive : this.drives) {
            CompetenceTest.DummyListener l = new CompetenceTest.DummyListener();
            this.instance.addElementListener((PoshElementListener)l);
            this.instance.addDrive(drive);
            Assert.assertTrue((boolean)this.instance.getDrives().contains(drive));
            Assert.assertEquals((Object)drive, (Object)l.lastAddedChild);
            this.instance.removeElementListener((PoshElementListener)l);
        }
    }

    @Test
    public void testSetGetName() throws InvalidNameException {
        System.out.println("set/getName");
        System.out.println("get/setName");
        String namePrefix = "repeat.ad.nauseum-";
        String oldName = this.instance.getName();
        for (int i = 0; i < 1000; ++i) {
            CompetenceTest.DummyListener l = new CompetenceTest.DummyListener();
            this.instance.addElementListener((PoshElementListener)l);
            this.instance.setName(namePrefix + i);
            String expResult = namePrefix + i;
            String newName = this.instance.getName();
            Assert.assertEquals((Object)expResult, (Object)newName);
            Assert.assertEquals((Object)"dcName", (Object)l.lastPropertyChange.getPropertyName());
            Assert.assertEquals((Object)oldName, (Object)l.lastPropertyChange.getOldValue());
            Assert.assertEquals((Object)expResult, (Object)l.lastPropertyChange.getNewValue());
            this.instance.removeElementListener((PoshElementListener)l);
            oldName = this.instance.getName();
        }
    }

    @Test(expected=DuplicateNameException.class)
    public void testRemoveDriveDuplName() throws DuplicateNameException {
        System.out.println("removeDrive - duplicate name");
        this.instance.addDrive(LapElementsFactory.createDriveElement((String)"Hello"));
        this.instance.addDrive(LapElementsFactory.createDriveElement((String)"Hello"));
    }

    @Test
    public void testRemoveDrive() throws Exception {
        System.out.println("removeDrive");
        for (DriveElement drive : this.drives) {
            this.instance.addDrive(drive);
        }
        IElementMethod<DriveCollection, DriveElement> action = new IElementMethod<DriveCollection, DriveElement>(){

            @Override
            public void method(DriveCollection element, DriveElement child) {
                element.removeDrive(child);
            }
        };
        RemoveTest<DriveCollection, DriveElement> test = new RemoveTest<DriveCollection, DriveElement>(this.instance, this.drives, action, 1);
        test.runTest();
    }
}

