/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.Adopt;
import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.exceptions.MissingParameterException;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AdoptParams
extends Assert {
    private FormalParameters params;
    private Adopt adopt;

    @Before
    public void before() {
        this.params = new FormalParameters();
        this.params.add((Object)new FormalParameters.Parameter("$param", (Object)"$param value"));
        Arguments args = new Arguments();
        args.addFormal((Arguments.Argument)new Arguments.ValueArgument("$valueArg", (Object)"$valueArg value"), this.params);
        args.addFormal((Arguments.Argument)new Arguments.VariableArgument("$variableArg", "$param"), this.params);
        PrimitiveCall call = new PrimitiveCall("primitive", args);
        this.adopt = new Adopt("adopt-element", this.params, Collections.emptyList(), call);
    }

    @Test(expected=MissingParameterException.class)
    public void missingParam() throws MissingParameterException {
        FormalParameters empty = new FormalParameters();
        this.adopt.setParameters(empty);
    }

    @Test
    public void changeParams() throws MissingParameterException {
        FormalParameters newParams = new FormalParameters();
        newParams.add((Object)new FormalParameters.Parameter("$headParam", (Object)"$headParam value"));
        newParams.add((Object)new FormalParameters.Parameter("$param", (Object)"$param new value"));
        newParams.add((Object)new FormalParameters.Parameter("$tailParam", (Object)"$tailParam value"));
        this.adopt.setParameters(newParams);
    }

    public void listenerNotified() throws MissingParameterException {
        FormalParameters newParams = new FormalParameters();
        newParams.add((Object)new FormalParameters.Parameter("$param", (Object)"$param new value"));
        PropertyTestListener listener = new PropertyTestListener("$param", this.params, newParams);
        this.adopt.addElementListener(listener);
        this.adopt.setParameters(newParams);
        AdoptParams.assertTrue((String)"Listener wasn't notified", (boolean)listener.wasCalled());
        this.adopt.removeElementListener(listener);
    }

    class PropertyTestListener<PARENT extends PoshElement>
    implements PoshElementListener<PARENT> {
        private final String propertyName;
        private final Object oldValue;
        private final Object newValue;
        private boolean changed = false;

        public PropertyTestListener(String propertyName, Object oldValue, Object newValue) {
            this.propertyName = propertyName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Assert.assertEquals((String)"Property name not equal", (Object)this.propertyName, (Object)evt.getPropertyName());
            Assert.assertEquals((String)"Old value not equal", (Object)this.oldValue, (Object)evt.getOldValue());
            Assert.assertEquals((String)"New value not equal", (Object)this.newValue, (Object)evt.getNewValue());
        }

        public boolean wasCalled() {
            return this.changed;
        }

        public void childElementAdded(PARENT parent, PoshElement child) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void childElementMoved(PARENT parent, PoshElement child, int oldIndex, int newIndex) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void childElementRemoved(PARENT parent, PoshElement child, int removedChildPosition) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

