/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.AbstractExecutor;
import cz.cuni.amis.pogamut.sposh.engine.DEExecutor;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.SystemClockTimer;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

final class DCExecutor
extends AbstractExecutor {
    private SenseListExecutor goalExecutor;
    List<DEExecutor> deExecutors = new ArrayList<DEExecutor>();
    private ITimer timer;
    private TriggerResult triggerResult;

    protected DCExecutor(PoshPlan plan, VariableContext ctx) {
        this(plan, ctx, new SystemClockTimer(), null);
    }

    protected DCExecutor(PoshPlan plan, VariableContext ctx, ITimer timer, Logger log) {
        super(ctx, log);
        DriveCollection dc = plan.getDriveCollection();
        this.timer = timer;
        this.goalExecutor = new SenseListExecutor(dc.getGoal(), ctx, log);
        for (DriveElement de : dc.getDrives()) {
            this.deExecutors.add(new DEExecutor(plan, de, ctx, log));
        }
    }

    public synchronized PoshEngine.EvaluationResultInfo fire(IWorkExecutor workExecuter) {
        FireResult.Type resultType = null;
        this.triggerResult = this.goalExecutor.fire(workExecuter, false);
        if (this.triggerResult.wasSuccess()) {
            return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.GOAL_SATISFIED, FireResult.Type.FULFILLED);
        }
        for (DEExecutor deExecutor : this.deExecutors) {
            deExecutor.clearTriggerResult();
        }
        for (DEExecutor deExecutor : this.deExecutors) {
            if (!deExecutor.isReady(this.timer.getTime(), workExecuter)) continue;
            resultType = deExecutor.fire(workExecuter, this.timer);
            return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.ELEMENT_FIRED, resultType);
        }
        return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.NO_ELEMENT_FIRED, FireResult.Type.FAILED);
    }

    ElementStackTrace getStackForDE(int index) {
        return this.deExecutors.get(index).getStackTrace();
    }

    ElementStackTrace getStackForDE(String name) {
        DEExecutor result = null;
        for (DEExecutor de : this.deExecutors) {
            boolean bl = de.getName() == null ? name == null : de.getName().equals(name);
            boolean equal = bl;
            if (!equal) continue;
            if (result == null) {
                result = de;
                continue;
            }
            throw new IllegalStateException("Two drive elements with name \"" + name + "\".");
        }
        if (result != null) {
            return result.getStackTrace();
        }
        return null;
    }

    public TriggerResult getTriggerResult() {
        return this.triggerResult;
    }
}

