/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;

public class TriggeredAction
extends NamedLapElement
implements Comparable<TriggeredAction> {
    public static final String taName = "taName";
    private Sense.SenseCall actionCall;
    public static final DataFlavor dataFlavor = new DataFlavor(TriggeredAction.class, "triggered_action");

    public TriggeredAction(String actionName) {
        this.actionCall = new Sense.SenseCall(actionName);
    }

    public TriggeredAction(Sense.SenseCall actionCall) {
        this.actionCall = actionCall;
    }

    public List<PoshElement> getChildDataNodes() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.actionCall.toString();
    }

    @Override
    public String getName() {
        return this.actionCall.getName();
    }

    public Sense.SenseCall getActionCall() {
        return this.actionCall;
    }

    protected boolean detectCycle() {
        int addedItems;
        PoshPlan root = this.getRootNode();
        if (root == null) {
            throw new RuntimeException("Missing root node.");
        }
        HashSet<String> connected = new HashSet<String>();
        connected.add(this.getName());
        do {
            String[] connectedArray;
            addedItems = 0;
            for (String processedAction : connectedArray = connected.toArray(new String[0])) {
                List<String> compositeChildren = root.getAPorCompActions(processedAction);
                for (String compositeChild : compositeChildren) {
                    if (this.getName().equals(compositeChild)) {
                        return true;
                    }
                    if (connected.contains(compositeChild)) continue;
                    connected.add(compositeChild);
                    ++addedItems;
                }
            }
        } while (addedItems > 0);
        return false;
    }

    public void setActionName(String actionName) {
        if (!(actionName = actionName.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw new IllegalArgumentException("Invalid name.");
        }
        String oldName = this.getName();
        this.actionCall = new Sense.SenseCall(actionName, this.actionCall.getParameters());
        if (this.getRootNode() != null && this.getRootNode().isCycled()) {
            this.actionCall = new Sense.SenseCall(oldName, this.actionCall.getParameters());
            JOptionPane.showMessageDialog(null, "This namechange is causing cycle, please use another name.", "Cycle detected", 0);
        } else {
            this.firePropertyChange(taName, null, actionName);
        }
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return false;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        throw new RuntimeException("TriggeredActions doesn't have children.");
    }

    @Override
    public int compareTo(TriggeredAction o) {
        return this.getName().compareTo(o.getName());
    }
}

