package cz.cuni.amis.pogamut.sposh.elements;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Test some methods of value.
 * @author Honza
 */
public class ValueTest {

    public ValueTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }


    private void testValueFail(String value, Class clazz) {
        if (clazz.isInstance(Result.parseValue(value))) {
            fail("Value created from string \"" + value + "\" is " + clazz.getSimpleName() + ", but shouldn't be.");
        }
    }

    private void testValueSucceed(String value, Class clazz) {
        Object result = Result.parseValue(value);
        if (!clazz.isInstance(result)) {
            fail("Value created from string \"" + value + "\" is not " + clazz + " but " + result.getClass());
        }
    }

    @Test
    public void testCreateValue() {
        System.out.println("createValue");

        // Result.parseValue(null); "Null is not parsable value"

        if (Result.parseValue("nil") != null) {
            fail("nil should be translated to null");
        }
        testValueSucceed("true", Boolean.class);
        testValueSucceed("True", Boolean.class);
        testValueFail("TRue", Boolean.class);
        testValueSucceed("False", Boolean.class);
        testValueSucceed("false", Boolean.class);
        testValueFail("falSe", Boolean.class);

        testValueSucceed("-12", Integer.class);
        testValueSucceed("12", Integer.class);
        testValueFail("12.0", Integer.class);
        testValueFail("12.0d", Integer.class);

        testValueSucceed("99.0", Double.class);
        testValueSucceed("-345.75", Double.class);
        testValueSucceed(".54", Double.class);
        testValueSucceed("-.88", Double.class);
        testValueFail(".8.4", Double.class);
    }
}
