package cz.cuni.amis.pogamut.sposh.elements;

/**
 * Ancestor class for lap elements with name. Most of the elements have a name,
 * but some (e.g. {@link Goal)) don't.
 *
 * @author HonzaH
 */
public abstract class NamedLapElement extends PoshDummyElement {

    /**
     * Get name of the element. The actual name, not display name (e.g. action
     * can have FQN of class, but display name would be derived fromk
     * annotations of the class) or representation (e.g. sense name "health" is
     * different from actual condition of sense "health > 90").
     *
     * @return Name of the element
     */
    public abstract String getName();
}
