/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.NamedLapElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.UnexpectedElementException;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DriveCollection
extends NamedLapElement {
    private String name;
    private Goal goal;
    private final List<DriveElement> elements = new LinkedList<DriveElement>();
    private final List<DriveElement> elementsUm = Collections.unmodifiableList(this.elements);
    public static final String dcName = "dcName";
    public static final DataFlavor dataFlavor = new DataFlavor(DriveCollection.class, "drive-collection-node");

    DriveCollection(String name, Goal goal, List<DriveElement> drives) {
        assert (goal != null);
        assert (goal.getParent() == null);
        assert (drives != null);
        this.name = name;
        this.goal = goal;
        this.goal.setParent(this);
        for (DriveElement element : drives) {
            assert (element.getParent() == null);
            this.elements.add(element);
            element.setParent(this);
        }
    }

    public void addDrive(DriveElement drive) throws DuplicateNameException {
        if (drive.getParent() != null) assert (!drive.getParent().getChildDataNodes().contains(drive));
        if (DriveCollection.isUsedName(drive.getName(), this.elements)) {
            throw new DuplicateNameException("DC " + this.name + " already have drive with name " + drive.getName());
        }
        this.elements.add(drive);
        drive.setParent(this);
        this.emitChildNode(drive);
    }

    public void setGoalNode(Goal goal) {
        this.goal.remove();
        this.goal = goal;
        goal.setParent(this);
        this.emitChildNode(goal);
    }

    public Goal getGoal() {
        return this.goal;
    }

    public List<DriveElement> getDrives() {
        return this.elementsUm;
    }

    public String toString() {
        String res = "\t(DC " + this.name + " " + this.goal.toString() + '\n';
        res = res + "\t\t(drives \n";
        for (DriveElement element : this.elements) {
            res = res + "\t\t\t  (" + element.toString() + ")\n";
        }
        res = res + "\t\t)\n";
        res = res + "\t)";
        return res;
    }

    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>(this.elements);
        children.add(0, (DriveElement)((Object)this.goal));
        return children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newName) throws InvalidNameException {
        if (!(newName = newName.trim()).matches("([a-zA-Z][_\\-a-zA-Z0-9]*\\.)*[a-zA-Z][_\\-a-zA-Z0-9]*")) {
            throw new InvalidNameException("Name " + newName + " is not valid.");
        }
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChange(dcName, oldName, this.name);
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return this.moveNodeInList(this.elements, child, relativePosition);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement child) throws DuplicateNameException {
        if (child instanceof Goal) {
            this.setGoalNode((Goal)child);
        } else if (child instanceof DriveElement) {
            this.addDrive((DriveElement)child);
        } else {
            throw new UnexpectedElementException("Class " + child.getClass().getSimpleName() + " not expected.");
        }
    }

    @Override
    public void neutralizeChild(PoshElement child) {
        if (child == this.goal) {
            this.setGoalNode(Goal.createFail());
        } else if (this.elements.contains(child)) {
            if (this.elements.size() == 1) {
                String unusedName = DriveCollection.getUnusedName("drive-", this.elementsUm);
                try {
                    this.addDrive(LapElementsFactory.createDriveElement(unusedName));
                }
                catch (DuplicateNameException ex) {
                    String msg = "Unused name " + unusedName + " is not unused.";
                    Logger.getLogger(DriveCollection.class.getName()).log(Level.SEVERE, msg, ex);
                    throw new FubarException(msg, ex);
                }
            }
            this.elements.remove(child);
            child.remove();
        } else {
            throw new UnexpectedElementException("Not expecting " + child.toString());
        }
    }
}

