/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.ElementList;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.SolTime;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;

public class ActionPattern
extends PoshDummyElement
implements Comparable<ActionPattern> {
    String _name;
    SolTime _timeout;
    ElementList<TriggeredAction> _actions;
    String _comment;
    public static final String apName = "apName";
    public static final String apTimeoutAmmount = "apTimeoutAmmount";
    public static final String apTimeoutUnits = "apTimeoutUnits";
    public static final String apComment = "apComment";
    public static final DataFlavor dataFlavor = new DataFlavor(ActionPattern.class, "action-pattern-node");
    protected FormalParameters parameters = new FormalParameters();

    public ActionPattern(String name) {
        this(name, new SolTime(), new ElementList<TriggeredAction>(new TriggeredAction[]{new TriggeredAction("do_nothing")}), "");
    }

    ActionPattern(String name, SolTime solTime, ElementList<TriggeredAction> ap, String comment) {
        this._name = name;
        this._timeout = solTime == null ? new SolTime() : solTime;
        this._actions = ap;
        this._comment = comment;
        for (TriggeredAction action : ap) {
            action.setParent(this);
        }
    }

    public boolean addTriggeredAction(TriggeredAction action) {
        action.setParent(this);
        this._actions.add(action);
        PoshPlan root = this.getRootNode();
        if (root != null && root.isCycled()) {
            this._actions.remove(action);
            JOptionPane.showMessageDialog(null, "This action is causing cycle, please use another name.", "Cycle detected", 0);
            return false;
        }
        this.emitChildNode(action);
        return true;
    }

    public String toString() {
        String ret = "\t(AP " + this._name;
        if (this._timeout != null) {
            ret = ret + " " + this._timeout.toString();
        }
        ret = ret + " " + this._actions.toString();
        if (this._comment != null && this._comment.length() > 0) {
            ret = ret + " \"" + this._comment + '\"';
        }
        return ret + ")\n";
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        return new ArrayList<PoshElement>(this._actions);
    }

    public void setNodeComment(String comment) {
        if (comment != null && comment.contains("\"")) {
            return;
        }
        String oldComment = this._comment;
        this._comment = comment;
        this.firePropertyChange(apComment, oldComment, comment);
    }

    public String getNodeComment() {
        return this._comment;
    }

    public Double getNodeTimeoutAmmount() {
        return this._timeout.getCount();
    }

    public void setNodeTimeoutAmmount(Double a) {
        if (a != null) {
            this._timeout.setCount(a);
            this.firePropertyChange(apTimeoutAmmount, null, a);
        }
    }

    public Integer getNodeTimeoutUnits() {
        return this._timeout.getUnits().getId();
    }

    public void setNodeTimeoutUnits(Integer newUnitsId) {
        if (newUnitsId != null) {
            for (SolTime.TimeUnits unit : SolTime.TimeUnits.values()) {
                if (unit.getId() != newUnitsId.intValue()) continue;
                this._timeout.setUnits(unit);
                this.firePropertyChange(apTimeoutUnits, null, (Object)unit);
            }
        }
    }

    public void setNodeName(String name) throws ParseException {
        if ((name = name.trim()).matches("[_a-zA-Z][_\\-a-zA-Z0-9]*")) {
            if (!this.getNodeName().equals(name) && this.getRootNode() != null && !this.getRootNode().isUniqueAPorComp(name)) {
                String msg = "New name for action pattern '" + this._name + "'(" + name + ") is not unique for reaction plan.";
                JOptionPane.showMessageDialog(null, msg, "Duplicate name", 0);
                return;
            }
            String oldName = this._name;
            this._name = name;
            if (this.getRootNode() != null && this.getRootNode().isCycled()) {
                this._name = oldName;
                String msg = "New name (" + name + ") for action pattern '" + this.getNodeName() + "' is causing cycle.";
                JOptionPane.showMessageDialog(null, msg, "Cycle detected", 0);
                return;
            }
            this.firePropertyChange(apName, null, name);
        }
    }

    public String getNodeName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this.getNodeName();
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return this.moveNodeInList(this._actions, child, relativePosition);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (!(newChild instanceof TriggeredAction)) {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
        this.addTriggeredAction((TriggeredAction)newChild);
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (this._actions.contains(childNode)) {
            if (this._actions.size() <= 1) {
                this.addTriggeredAction(new TriggeredAction("do_nothing"));
            }
            this._actions.remove(childNode);
            childNode.remove();
        }
    }

    public List<TriggeredAction> getTriggeredActions() {
        return Collections.unmodifiableList(this._actions);
    }

    @Override
    public int compareTo(ActionPattern o) {
        return this.toString().compareTo(o.toString());
    }

    void setTimeout(SolTime t) {
        this.setNodeTimeoutAmmount(t.getCount());
        this.setNodeTimeoutUnits(t.getUnits().getId());
    }

    protected void setParameters(FormalParameters parameters) {
        this.parameters = new FormalParameters(parameters);
    }

    public FormalParameters getParameters() {
        return this.parameters;
    }
}

