/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.elements;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.DrivePriorityElement;
import cz.cuni.amis.pogamut.sposh.elements.Goal;
import cz.cuni.amis.pogamut.sposh.elements.PoshDummyElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class DriveCollection
extends PoshDummyElement {
    private String _name;
    private Goal _goal;
    private List<DrivePriorityElement> _elements;
    public static final String dcName = "dcName";
    public static final DataFlavor dataFlavor = new DataFlavor(DriveCollection.class, "drive-collection-node");

    DriveCollection(String name, Goal goal, List<DrivePriorityElement> drives) {
        this._name = name;
        this._goal = goal;
        this._elements = drives;
        if (this._goal != null) {
            this._goal.setParent(this);
        }
        for (DrivePriorityElement element : drives) {
            element.setParent(this);
        }
    }

    public void addDrivePriorityElement(DrivePriorityElement element) {
        element.setParent(this);
        this._elements.add(element);
        this.emitChildNode(element);
    }

    public void setGoalNode(Goal goal) {
        if (this._goal != null) {
            this._goal.remove();
        }
        this._goal = goal;
        goal.setParent(this);
        this.emitChildNode(goal);
    }

    public Goal getGoal() {
        return this._goal;
    }

    public String toString() {
        String res = "\t(SDC " + this.getDriveCollectionName();
        res = res + " " + (this._goal == null ? "" : this._goal.toString());
        res = res + "\n\t\t(drives ";
        for (DrivePriorityElement drive : this._elements) {
            res = res + "\n\t\t\t  (" + drive.toString() + ")";
        }
        res = res + "\n\t\t)";
        res = res + "\n\t)";
        return res;
    }

    @Override
    public List<PoshElement> getChildDataNodes() {
        ArrayList<PoshElement> children = new ArrayList<PoshElement>(this._elements);
        if (this._goal != null) {
            children.add(0, this._goal);
        }
        return children;
    }

    public String getDriveCollectionName() {
        return this._name;
    }

    public void setDriveCollectionName(String collectionName) {
        if ((collectionName = collectionName.trim()).matches("[_a-zA-Z][_\\-a-zA-Z0-9]*")) {
            this._name = collectionName;
            this.firePropertyChange(dcName, null, collectionName);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getDriveCollectionName();
    }

    @Override
    public boolean moveChild(PoshElement child, int relativePosition) {
        return this.moveNodeInList(this._elements, child, relativePosition);
    }

    @Override
    public DataFlavor getDataFlavor() {
        return dataFlavor;
    }

    @Override
    public void addChildDataNode(PoshElement newChild) {
        if (newChild instanceof Goal) {
            this.setGoalNode((Goal)newChild);
        } else if (newChild instanceof DrivePriorityElement) {
            this.addDrivePriorityElement((DrivePriorityElement)newChild);
        } else {
            throw new RuntimeException("Class " + newChild.getClass().getSimpleName() + " not accepted.");
        }
    }

    @Override
    public void neutralizeChild(PoshElement childNode) {
        if (childNode == this._goal) {
            this.setGoalNode(new Goal(new Sense("fail")));
        } else if (this._elements.contains(childNode)) {
            if (this._elements.size() <= 1) {
                this.addDrivePriorityElement(new DrivePriorityElement(new DriveElement("drive", new Triggers(new Sense("fail")), "do_nothing", null)));
            }
            this._elements.remove(childNode);
            childNode.remove();
        }
    }

    public List<DrivePriorityElement> getPriorityElements() {
        return Collections.unmodifiableList(this._elements);
    }

    public LinkedList<DriveElement> getDrives() {
        LinkedList<DriveElement> drives = new LinkedList<DriveElement>();
        for (DrivePriorityElement dpe : this._elements) {
            for (DriveElement drive : dpe.getDriveElements()) {
                drives.add(drive);
            }
        }
        return drives;
    }
}

