/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.executor;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.IAction;
import cz.cuni.amis.pogamut.sposh.executor.ISense;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Logger;

public class StateWorkExecutor
implements IWorkExecutor {
    protected final HashMap<String, IAction> actions = new HashMap();
    protected final HashMap<String, ISense> senses = new HashMap();
    protected String current;
    protected Logger log;

    public StateWorkExecutor() {
        this.log = Logger.getLogger(this.getClass().getSimpleName());
    }

    public StateWorkExecutor(Logger log) {
        this.log = log;
    }

    public Logger getLogger() {
        return this.log;
    }

    public synchronized boolean isNameUsed(String name) {
        return this.isSense(name) || this.isAction(name);
    }

    protected boolean isAction(String name) {
        return this.actions.containsKey(name);
    }

    protected boolean isSense(String name) {
        return this.senses.containsKey(name);
    }

    public synchronized void addAction(String name, IAction action) {
        if (this.isNameUsed(name)) {
            throw new IllegalArgumentException("Primtive with name \"" + name + "\" is already present in executor.");
        }
        this.actions.put(name, action);
    }

    public synchronized void addSense(String name, ISense sense) {
        if (this.isNameUsed(name)) {
            throw new IllegalArgumentException("Primtive with name \"" + name + "\" is already present in executor.");
        }
        this.senses.put(name, sense);
    }

    public void addAction(IAction action) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addSense(ISense sense) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized Object executePrimitive(String primitive, VariableContext ctx) {
        boolean samePrimtive;
        if (this.isSense(primitive)) {
            return this.senses.get(primitive).query(ctx);
        }
        if (!this.isAction(primitive)) {
            throw new IllegalArgumentException("Primitive \"" + primitive + "\" is not specified in the worker.");
        }
        IAction currentPrimitive = this.actions.get(this.current);
        boolean bl = this.current == null ? primitive == null : (samePrimtive = this.current.equals(primitive));
        if (!samePrimtive) {
            if (currentPrimitive != null) {
                this.log.info(MessageFormat.format("{0}.DONE({1})", this.current, ctx));
                currentPrimitive.done(ctx);
            }
            this.current = primitive;
            currentPrimitive = this.actions.get(this.current);
            this.log.info(MessageFormat.format("{0}.INIT({1})", this.current, ctx));
            currentPrimitive.init(ctx);
        }
        Object result = currentPrimitive.run(ctx);
        this.log.info(MessageFormat.format("{0}.RUN({1}) = {2}", this.current, ctx, result));
        return result;
    }
}

