/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.ElementStackTrace;
import cz.cuni.amis.pogamut.sposh.engine.ITestPrimitive;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.PrintPrimitive;
import cz.cuni.amis.pogamut.sposh.engine.TestWorkExecutor;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.DebugTimer;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.executor.IAction;
import cz.cuni.amis.pogamut.sposh.executor.ISense;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import cz.cuni.amis.pogamut.sposh.executor.StateWorkExecutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PoshEngineTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private String loadPlan(String relativeResourcePath) throws IOException {
        String resourcePath = this.getClass().getPackage().getName().replace('.', '/') + '/' + relativeResourcePath;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (is == null) {
            Assert.fail((String)("Unable to open resource \"" + resourcePath + "\""));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            sb.append(line);
            sb.append('\n');
        }
        reader.close();
        return sb.toString();
    }

    private PoshPlan parsePlan(String relativeResourcePath) throws IOException, ParseException {
        System.out.println("Parse plan: " + relativeResourcePath);
        String plan = this.loadPlan(relativeResourcePath);
        PoshParser parser = new PoshParser((Reader)new StringReader(plan));
        return parser.parsePlan();
    }

    private String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    private IWorkExecutor createWorkExecutor() {
        return new IWorkExecutor(){

            public Object executePrimitive(String primitive, VariableContext ctx) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Test
    public void testGoalFulfilled() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestGoalFulfilled.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false)});
        PoshEngine.EvaluationResult result = poshEngine.evaluatePlan((IWorkExecutor)workExecuter);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.GOAL_SATISFIED, (Object)result);
    }

    @Test
    public void testParameterlessPrimitiveEvaluation() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestPrimitiveEvaluation.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive dummyPrimitive = new PrintPrimitive("dummyPrimitive", false){

            @Override
            public Object work(VariableContext ctx) {
                Assert.assertEquals((long)ctx.size(), (long)0L);
                return super.work(ctx);
            }
        };
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), dummyPrimitive});
        Assert.assertEquals((Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter), (Object)PoshEngine.EvaluationResult.ELEMENT_FIRED);
        if (dummyPrimitive.triggered() != 0) {
            Assert.fail((String)"Primitive was triggered, shouldn't be, expected only to add primitive to stack.");
        }
        Assert.assertEquals((Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter), (Object)PoshEngine.EvaluationResult.ELEMENT_FIRED);
        if (dummyPrimitive.triggered() != 1) {
            Assert.fail((String)"Primitive wasn't triggered.");
        }
    }

    @Test
    public void testDEFrequencyFail() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        DebugTimer timer = new DebugTimer();
        PoshEngine poshEngine = new PoshEngine(this.parsePlan("testplans/TestDEFrequencyFail.lap"), (ITimer)timer);
        PrintPrimitive doNothingPrimitive = new PrintPrimitive("doNothing", false);
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("fail", false), doNothingPrimitive});
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.NO_ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.NO_ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            timer.addTime(250L);
            if (doNothingPrimitive.triggered() == 1) continue;
            Assert.fail((String)"DE wasn't triggered just once");
        }
        System.out.println("Adding 300 so it is over 1000ms");
        timer.addTime(300L);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (doNothingPrimitive.triggered() != 2) {
            Assert.fail((String)"DE wasn't triggered after freq limiter timeout");
        }
    }

    @Test
    public void testNoGoal() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestNoGoal.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive dummyPrimitive = new PrintPrimitive("dummyPrimitive", false);
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{dummyPrimitive});
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (dummyPrimitive.triggered() != 0) {
            Assert.fail((String)"Primitive was triggered, should only be added to stack.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (dummyPrimitive.triggered() != 1) {
            Assert.fail((String)"Primitive wasn't triggered.");
        }
    }

    @Test
    public void testAPExecutor() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestAPExecutor.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ITestPrimitive[] actions = new ITestPrimitive[3];
        int[] res = new int[]{0, 0, 0};
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = new PrintPrimitive("action" + i);
        }
        TestWorkExecutor workExecuter = new TestWorkExecutor(actions);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        this.checkPrimitives(actions, res);
        for (int i = 0; i < actions.length; ++i) {
            System.out.println(" * Firing action " + actions[i].getName());
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            this.checkPrimitives(actions, res);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            res[i] = 1;
            this.checkPrimitives(actions, res);
        }
    }

    private void checkPrimitives(ITestPrimitive[] primitives, int[] results) {
        for (int i = 0; i < primitives.length; ++i) {
            if (primitives[i].triggered() == results[i]) continue;
            throw new IllegalStateException("Primitive " + primitives[i].getName() + " wasn't triggered " + results[i] + " times, but " + primitives[i].triggered());
        }
    }

    @Test
    public void testPassedConstantsInPrimitive() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestPrimitiveVariables.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ITestPrimitive testVariable = new ITestPrimitive(){

            @Override
            public String getName() {
                return "testVariable";
            }

            @Override
            public Object work(VariableContext ctx) {
                if (!"Snowhite".equals(ctx.getValue("$name"))) {
                    throw new IllegalStateException("Variable $name is not snowhite, but " + ctx.getValue("$name"));
                }
                Assert.assertEquals((Object)ctx.getValue("0"), (Object)12.4);
                if (ctx.size() != 2) {
                    throw new IllegalStateException("More than two variables passed (\"" + ctx.size() + "\").");
                }
                return null;
            }

            @Override
            public int triggered() {
                return 0;
            }
        };
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{testVariable});
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
    }

    @Test
    public void testNestedAP() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestNestedAP.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        int[] res = new int[]{0, 0, 0, 0};
        ITestPrimitive[] actions = new ITestPrimitive[4];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = new PrintPrimitive("action" + i);
        }
        TestWorkExecutor workExecuter = new TestWorkExecutor(actions);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        res[0] = res[0] + 1;
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        res[1] = res[1] + 1;
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        res[2] = res[2] + 1;
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        this.checkPrimitives(actions, res);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        res[3] = res[3] + 1;
        this.checkPrimitives(actions, res);
    }

    @Test
    public void testNestedAPFailure() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestNestedAPFailure.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        int[] res = new int[]{0, 0, 0, 0};
        ITestPrimitive[] actions = new ITestPrimitive[4];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = i == 2 ? new PrintPrimitive("action" + i, false) : new PrintPrimitive("action" + i);
        }
        TestWorkExecutor workExecuter = new TestWorkExecutor(actions);
        for (int loop = 0; loop < 4; ++loop) {
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            this.checkPrimitives(actions, res);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            this.checkPrimitives(actions, res);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            res[0] = res[0] + 1;
            this.checkPrimitives(actions, res);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            this.checkPrimitives(actions, res);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            this.checkPrimitives(actions, res);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            res[1] = res[1] + 1;
            this.checkPrimitives(actions, res);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            this.checkPrimitives(actions, res);
            System.out.println("Action2 will fail, reset");
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            res[2] = res[2] + 1;
            this.checkPrimitives(actions, res);
            System.out.println("Stack has been reseted.");
        }
    }

    @Test
    public void testSimpleC() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestSimpleC.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive action = new PrintPrimitive("action");
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{action});
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 0) {
            Assert.fail((String)"Action was fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 0) {
            Assert.fail((String)"Action was fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 0) {
            Assert.fail((String)"Action was fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 1) {
            Assert.fail((String)"Action wasn't fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 1) {
            Assert.fail((String)"Action wasn't fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 1) {
            Assert.fail((String)"Action shouldn't be fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 1) {
            Assert.fail((String)"Action shouldn't be fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 2) {
            Assert.fail((String)"Action should have been fired twice.");
        }
    }

    @Test
    public void testSimpleCRetry() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/TestSimpleCRetry.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive action = new PrintPrimitive("action");
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{action});
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        if (action.triggered() != 0) {
            Assert.fail((String)"Action was fired.");
        }
        int retries = 6;
        for (int i = 0; i < 6; ++i) {
            System.out.println("i" + i);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            if (action.triggered() != 0 + i) {
                Assert.fail((String)"Action was fired.");
            }
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            if (action.triggered() != 0 + i) {
                Assert.fail((String)"Action was fired.");
            }
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            if (action.triggered() != 1 + i) {
                Assert.fail((String)"Action wasn't fired.");
            }
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
            if (action.triggered() == 1 + i) continue;
            Assert.fail((String)"Action wasn't fired.");
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        Assert.assertEquals((long)0L, (long)poshEngine.getStackForDE("testDE").size());
    }

    @Test
    public void test011VarConstPassed2Primitive() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/011VarConstPassed2Primitive.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive murder = new PrintPrimitive("murder"){

            private boolean variableInContext(VariableContext ctx, String contextName, String value) {
                Object contextValue = ctx.getValue(contextName);
                return value == null ? contextValue == null : value.equals(contextValue);
            }

            private void assertVariableInContext(VariableContext ctx, String contextName, String value) {
                Assert.assertTrue((String)("Variable \"" + contextName + "\" is not \"" + value + "\", but " + ctx.getValue(contextName)), (boolean)this.variableInContext(ctx, contextName, value));
            }

            @Override
            public Object work(VariableContext ctx) {
                if (ctx.size() != 5) {
                    Assert.fail((String)("Expected 5 variables, is " + ctx.size()));
                }
                this.assertVariableInContext(ctx, "0", "'killAllHumans");
                Assert.assertEquals((Object)ctx.getValue("1"), (Object)12.6);
                this.assertVariableInContext(ctx, "2", "Tomorrow");
                this.assertVariableInContext(ctx, "$method", "brutal");
                this.assertVariableInContext(ctx, "$baka", "Sekal");
                return super.work(ctx);
            }
        };
        TestWorkExecutor workExecuter = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), murder});
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        Enumeration enumerator = poshEngine.getStackForDE("stay").elements();
        while (enumerator.hasMoreElements()) {
            ElementStackTrace.StackElement stackElement = (ElementStackTrace.StackElement)enumerator.nextElement();
            VariableContext ctx = stackElement.getExecutor().getVariableContext();
            System.out.println("Keys for " + stackElement.toString());
            for (String key : ctx.getKeys()) {
                System.out.println(" - \"" + key + "\" " + ctx.getValue(key));
            }
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)workExecuter));
        Assert.assertTrue((murder.triggered() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void test012TestAPProcessing() throws IOException, ParseException {
        int i;
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/012TestAPProcessing.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive succeed = new PrintPrimitive("succeed", true);
        PrintPrimitive fail = new PrintPrimitive("fail", false);
        ITestPrimitive[] ok = new ITestPrimitive[]{new PrintPrimitive("ok1", true), new PrintPrimitive("ok2", true), new PrintPrimitive("ok3", true)};
        PrintPrimitive fail1 = new PrintPrimitive("fail1", false);
        PrintPrimitive last = new PrintPrimitive("last", true);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{succeed, fail, ok[0], ok[1], ok[2], fail1, last});
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
            Assert.assertTrue((ok[i].triggered() == 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
            Assert.assertTrue((ok[i].triggered() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
        Assert.assertTrue((fail1.triggered() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
        Assert.assertTrue((fail1.triggered() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
            Assert.assertTrue((String)("ok " + i + " was triggered " + ok[i].triggered()), (ok[i].triggered() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)poshEngine.evaluatePlan((IWorkExecutor)executor));
            Assert.assertTrue((String)("ok " + i + " was triggered " + ok[i].triggered()), (ok[i].triggered() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((last.triggered() == 0 ? 1 : 0) != 0);
        }
    }

    private void testPrimitiveExecutionOrder(PoshEngine engine, TestWorkExecutor executor, String[][] order) {
        HashMap<String, Integer> fired = new HashMap<String, Integer>();
        for (String key : executor.getPrimitives().keySet()) {
            fired.put(key, executor.getPrimitives().get(key).triggered());
        }
        for (int executionLoop = 0; executionLoop < order.length; ++executionLoop) {
            System.out.print(">>> Loop " + executionLoop + " [");
            for (String primitive : order[executionLoop]) {
                System.out.print(primitive + ", ");
            }
            System.out.println("]");
            Assert.assertEquals((Object)PoshEngine.EvaluationResult.ELEMENT_FIRED, (Object)engine.evaluatePlan((IWorkExecutor)executor));
            for (String triggeredPrimitive : order[executionLoop]) {
                if (!fired.containsKey(triggeredPrimitive)) {
                    Assert.fail((String)("Primitive \"" + triggeredPrimitive + "\" is not in executor list of primitives."));
                }
                fired.put(triggeredPrimitive, (Integer)fired.get(triggeredPrimitive) + 1);
            }
            for (String key : executor.getPrimitives().keySet()) {
                int supposedTriggerCount;
                int wasTriggeredCount = executor.getPrimitives().get(key).triggered();
                if (wasTriggeredCount == (supposedTriggerCount = ((Integer)fired.get(key)).intValue())) continue;
                Assert.fail((String)("Primtives \"" + key + "\" is supposed to be triggered " + supposedTriggerCount + " times, but was " + wasTriggeredCount + " in loop " + executionLoop + "\n" + order[executionLoop]));
            }
        }
    }

    @Test
    public void test012New() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/012TestAPProcessing.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), new PrintPrimitive("ok1", true), new PrintPrimitive("ok2", true), new PrintPrimitive("ok3", true), new PrintPrimitive("fail1", false), new PrintPrimitive("last", true)});
        String[][] primitivesOrder = new String[][]{{"fail", "succeed"}, {"fail", "succeed"}, {"fail", "succeed", "ok1"}, {"fail", "succeed"}, {"fail", "succeed", "ok2"}, {"fail", "succeed"}, {"fail", "succeed", "ok3"}, {"fail", "succeed"}, {"fail", "succeed", "fail1"}};
        for (int i = 0; i < 10; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test013TestDC() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/013DCSwitch.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive ok125 = new PrintPrimitive("ok125", true);
        PrintPrimitive ok3 = new PrintPrimitive("ok3", true);
        PrintPrimitive ok1234 = new PrintPrimitive("ok1234", true);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("fail", false), ok125, ok3, ok1234, new PrintPrimitive("action1", false), new PrintPrimitive("action2", true), new PrintPrimitive("action3", true)});
        String[][] primitivesOrder1 = new String[][]{{"fail", "ok125"}, {"fail", "ok125", "action1"}};
        String[][] primitivesOrder2 = new String[][]{{"fail", "ok125"}, {"fail", "ok125", "action1"}};
        String[][] primitivesOrder3 = new String[][]{{"fail", "ok125", "ok3"}, {"fail", "ok125", "ok3", "action2"}};
        String[][] primitivesOrder4 = new String[][]{{"fail", "ok125", "ok3", "ok1234"}, {"fail", "ok125", "ok3", "ok1234", "action3"}};
        String[][] primitivesOrder5 = new String[][]{{"fail", "ok125"}, {"fail", "ok125", "action1"}};
        ok125.setReturnValue(true);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder1);
        ok125.setReturnValue(true);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder2);
        ok125.setReturnValue(false);
        ok3.setReturnValue(true);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder3);
        ok125.setReturnValue(false);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder4);
        ok125.setReturnValue(true);
        ok3.setReturnValue(false);
        ok1234.setReturnValue(false);
        this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder5);
    }

    @Test
    public void test014Comparison() throws IOException, ParseException {
        int i;
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/014Comparison.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ValuePrimitive<Integer> value = new ValuePrimitive<Integer>("value", 0);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{value, new PrintPrimitive("action", false)});
        for (i = 0; i < 14; ++i) {
            value.setValue(i);
            Assert.assertTrue((poshEngine.evaluatePlan((IWorkExecutor)executor) != PoshEngine.EvaluationResult.GOAL_SATISFIED ? 1 : 0) != 0);
        }
        for (i = 14; i < 100; ++i) {
            value.setValue(i);
            Assert.assertTrue((String)(" Loop " + i), (poshEngine.evaluatePlan((IWorkExecutor)executor) == PoshEngine.EvaluationResult.GOAL_SATISFIED ? 1 : 0) != 0);
        }
    }

    @Test
    public void test015APDouble() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/015APdouble.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("action0", true), new PrintPrimitive("action1", true), new PrintPrimitive("action2", true), new PrintPrimitive("action3", true), new PrintPrimitive("action4", true)});
        String[][] primitivesOrder = new String[][]{new String[0], new String[0], {"action0"}, new String[0], new String[0], {"action1"}, new String[0], {"action2"}, new String[0], {"action3"}, new String[0], new String[0], {"action4"}, new String[0]};
        for (int i = 0; i < 10; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test016APDoubleFail() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/016APdoubleFail.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("action0", true), new PrintPrimitive("action1", true), new PrintPrimitive("action2", false), new PrintPrimitive("action3", true), new PrintPrimitive("action4", true)});
        String[][] primitivesOrder = new String[][]{new String[0], new String[0], {"action0"}, new String[0], new String[0], {"action1"}, new String[0], {"action2"}};
        for (int i = 0; i < 10; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test017MultiCE() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/017MultiCE.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("tr1", false), new PrintPrimitive("tr2", true), new PrintPrimitive("tr3", false), new PrintPrimitive("action", true), new PrintPrimitive("action0", true), new PrintPrimitive("action1", true)});
        String[][] primitivesOrder = new String[][]{new String[0], {"tr1", "tr2"}, new String[0], new String[0], {"action0"}, new String[0], {"action1"}, new String[0]};
        for (int i = 0; i < 20; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    @Test
    public void test018MultiC() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/018MultiC.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ValuePrimitive<Boolean> tr1 = new ValuePrimitive<Boolean>("tr1", true);
        ValuePrimitive<Boolean> tr2 = new ValuePrimitive<Boolean>("tr2", true);
        ValuePrimitive<Boolean> action = new ValuePrimitive<Boolean>("action", true);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{tr1, tr2, action});
        this.testPrimitiveExecutionOrder(poshEngine, executor, new String[][]{new String[0], {"tr1"}, new String[0]});
        for (int i = 0; i < 20; ++i) {
            System.out.println("++Loop " + i);
            this.testPrimitiveExecutionOrder(poshEngine, executor, new String[][]{{"tr2"}, new String[0], {"action"}, new String[0]});
        }
    }

    @Test
    public void test019MultiCGoal() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/019MultiCGoal.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        ValuePrimitive<Boolean> tr1 = new ValuePrimitive<Boolean>("tr1", true);
        ValuePrimitive<Boolean> tr2 = new ValuePrimitive<Boolean>("tr2", true);
        ValuePrimitive<Boolean> g1 = new ValuePrimitive<Boolean>("g1", false);
        ValuePrimitive<Boolean> g2 = new ValuePrimitive<Boolean>("g2", false);
        ValuePrimitive<Boolean> action = new ValuePrimitive<Boolean>("action", true);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{tr1, tr2, g1, g2, action});
        System.out.println("+++ PHASE 1");
        this.testPrimitiveExecutionOrder(poshEngine, executor, new String[][]{new String[0], {"g1", "tr1"}, new String[0]});
        for (int i = 0; i < 20; ++i) {
            System.out.println("++Loop " + i);
            this.testPrimitiveExecutionOrder(poshEngine, executor, new String[][]{{"g2", "tr2"}, new String[0], {"action"}, new String[0]});
        }
        System.out.println("+++ PHASE 2");
        poshEngine.reset();
        g2.setValue(true);
        this.testPrimitiveExecutionOrder(poshEngine, executor, new String[][]{new String[0], {"g1", "tr1"}, new String[0], {"g2"}});
        Assert.assertTrue((poshEngine.getStackForDE("testDE").size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test020SenseCtx() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/020SenseCtx.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        StateWorkExecutor stateWorkExecutor = new StateWorkExecutor();
        stateWorkExecutor.addAction("doNothing", new IAction(){

            public void init(VariableContext ctx) {
            }

            public Object run(VariableContext ctx) {
                return true;
            }

            public void done(VariableContext ctx) {
            }
        });
        stateWorkExecutor.addSense("playerClose", new ISense(){

            public Object query(VariableContext ctx) {
                if (ctx.size() != 3) {
                    Assert.fail((String)("Size is not 3, but " + ctx.size()));
                }
                Assert.assertEquals((Object)ctx.getValue("0"), (Object)12.4);
                Assert.assertEquals((Object)ctx.getValue("$second"), (Object)"brutal");
                Assert.assertEquals((Object)ctx.getValue("$third"), (Object)"lala");
                return true;
            }
        });
        poshEngine.evaluatePlan((IWorkExecutor)stateWorkExecutor);
        poshEngine.evaluatePlan((IWorkExecutor)stateWorkExecutor);
    }

    @Test
    public void test021TestEqualTrue() throws IOException, ParseException {
        System.out.println("\n === Test: " + this.getMethodName() + " ===");
        PoshPlan parsePlan = this.parsePlan("testplans/021TestEqualTrue.lap");
        PoshEngine poshEngine = new PoshEngine(parsePlan);
        PrintPrimitive something = new PrintPrimitive("something", true);
        PrintPrimitive nothing = new PrintPrimitive("doNothing", true);
        TestWorkExecutor executor = new TestWorkExecutor(new ITestPrimitive[]{new PrintPrimitive("succeed", true), new PrintPrimitive("fail", false), something, nothing});
        String[][] primitivesOrder = new String[][]{{"fail", "succeed"}, {"fail", "succeed", "something"}};
        for (int i = 0; i < 20; ++i) {
            this.testPrimitiveExecutionOrder(poshEngine, executor, primitivesOrder);
        }
    }

    private class ValuePrimitive<T>
    implements ITestPrimitive {
        private String name;
        private T value;
        private int triggered = 0;

        public ValuePrimitive(String name, T initialValue) {
            this.name = name;
            this.value = initialValue;
        }

        public void setValue(T value) {
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object work(VariableContext ctx) {
            ++this.triggered;
            return this.value;
        }

        @Override
        public int triggered() {
            return this.triggered;
        }
    }
}

