/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ILapChainListener;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.exceptions.UnexpectedElementException;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.INameMapListener;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import java.util.LinkedList;
import java.util.List;

public abstract class PrimitivePresenter<PRIMITIVE_TYPE extends PoshElement>
extends AbstractPresenter
implements PoshElementListener<PRIMITIVE_TYPE>,
INameMapListener,
ILapChainListener {
    protected final PRIMITIVE_TYPE primitive;
    protected final ShedWidget primitiveWidget;
    protected final LapChain primitiveChain;

    protected PrimitivePresenter(ShedScene scene, ShedPresenter presenter, PRIMITIVE_TYPE primitive, ShedWidget primitiveWidget, LapChain primitiveChain) {
        super(scene, presenter);
        this.primitive = primitive;
        this.primitiveWidget = primitiveWidget;
        this.primitiveChain = primitiveChain;
    }

    @Override
    public void register() {
        this.primitiveWidget.setPresenter(this);
        this.primitive.addElementListener((PoshElementListener)this);
        this.presenter.addNameMapListener(this);
        this.primitiveChain.register();
        this.primitiveChain.addChainListener((ILapChainListener)this);
        this.updateWidget();
    }

    @Override
    public void unregister() {
        this.primitiveChain.removeChainListener((ILapChainListener)this);
        this.primitiveChain.unregister();
        this.presenter.removeNameMapListener(this);
        this.primitive.removeElementListener((PoshElementListener)this);
        this.primitiveWidget.setPresenter(null);
    }

    public final void childElementAdded(PRIMITIVE_TYPE parent, PoshElement child) {
        throw UnexpectedElementException.create((PoshElement)child);
    }

    public final void childElementMoved(PRIMITIVE_TYPE parent, PoshElement child, int oldIndex, int newIndex) {
        throw UnexpectedElementException.create((PoshElement)child);
    }

    public final void childElementRemoved(PRIMITIVE_TYPE parent, PoshElement child, int removedChildIndex) {
        throw UnexpectedElementException.create((PoshElement)child);
    }

    @Override
    public final void nameMapChanged(String key, String oldName, String newName) {
        if (key.equals(((INamedElement)this.primitive).getName())) {
            this.updateWidget();
        }
    }

    public final void notifyLinkChanged() {
        this.updateWidget();
        this.scene.update();
    }

    protected abstract String getTitleText();

    protected final void updateWidget() {
        String titleText = this.getTitleText();
        this.primitiveWidget.setDisplayName(titleText);
        ParamInfo[] params = this.presenter.getPrimitiveParameters(((INamedElement)this.primitive).getName());
        VariableContext ctx = this.primitiveChain.createContext();
        List<ShedWidget.Variable> presentArgs = this.getPresentArgs(ctx, params);
        this.primitiveWidget.setPresent(presentArgs);
        List<ShedWidget.Variable> missingArgs = this.getErrorArgs(ctx, params);
        this.primitiveWidget.setError(missingArgs);
        List<ShedWidget.Variable> unusedArgs = this.getUnusedArgs(ctx, params);
        this.primitiveWidget.setUnused(unusedArgs);
        this.primitiveWidget.revalidate();
    }

    private boolean paramHasValue(ParamInfo param, VariableContext ctx) {
        return ctx.hasVariable(param.name);
    }

    private boolean parmValueHasCorrectType(ParamInfo param, VariableContext ctx) {
        Object paramValue = ctx.getValue(param.name);
        return param.isValueAssignable(paramValue);
    }

    private List<ShedWidget.Variable> getPresentArgs(VariableContext ctx, ParamInfo[] primitiveParams) {
        LinkedList<ShedWidget.Variable> presentArgs = new LinkedList<ShedWidget.Variable>();
        for (ParamInfo param : primitiveParams) {
            if (!this.paramHasValue(param, ctx) || !this.parmValueHasCorrectType(param, ctx)) continue;
            Object paramValue = ctx.getValue(param.name);
            ShedWidget.Variable var = new ShedWidget.Variable(param.name, param.type, Result.toLap((Object)paramValue), "");
            presentArgs.add(var);
        }
        return presentArgs;
    }

    private List<ShedWidget.Variable> getErrorArgs(VariableContext ctx, ParamInfo[] primitiveParams) {
        LinkedList<ShedWidget.Variable> errorArgs = new LinkedList<ShedWidget.Variable>();
        for (ParamInfo param : primitiveParams) {
            if (!this.paramHasValue(param, ctx)) {
                ShedWidget.Variable var = new ShedWidget.Variable(param.name, param.type, "", "Unspecified value");
                errorArgs.add(var);
                continue;
            }
            if (this.parmValueHasCorrectType(param, ctx)) continue;
            Object paramValue = ctx.getValue(param.name);
            ShedWidget.Variable var = new ShedWidget.Variable(param.name, param.type, Result.toLap((Object)paramValue), "Incorrect type");
            errorArgs.add(var);
        }
        return errorArgs;
    }

    private List<ShedWidget.Variable> getUnusedArgs(VariableContext ctx, ParamInfo[] params) {
        String[] allVariables;
        LinkedList<ShedWidget.Variable> unusedVars = new LinkedList<ShedWidget.Variable>();
        for (String variableName : allVariables = ctx.getKeys()) {
            boolean isVariableParam = false;
            for (ParamInfo param : params) {
                if (!param.name.equals(variableName)) continue;
                isVariableParam = true;
            }
            if (isVariableParam) continue;
            Object variableValue = ctx.getValue(variableName);
            ShedWidget.Variable var = new ShedWidget.Variable(variableName, null, Result.toLap((Object)variableValue), "");
            unusedVars.add(var);
        }
        return unusedVars;
    }
}

