/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.presenter.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.IPresenterFactory;
import cz.cuni.pogamut.shed.widget.ArrowWidget;
import cz.cuni.pogamut.shed.widget.AttachmentEnvelope;
import cz.cuni.pogamut.shed.widget.DragAndDropMoveProvider;
import cz.cuni.pogamut.shed.widget.ExpandedActionEnvelope;
import cz.cuni.pogamut.shed.widget.FixedWidgetAnchor;
import cz.cuni.pogamut.shed.widget.LeveledHorizontalAnchor;
import cz.cuni.pogamut.shed.widget.RightWidgetAnchor;
import cz.cuni.pogamut.shed.widget.ShedActionsEnvelope;
import cz.cuni.pogamut.shed.widget.ShedChoicesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedCollapseWidget;
import cz.cuni.pogamut.shed.widget.ShedCreationContainer;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedSenseWidget;
import cz.cuni.pogamut.shed.widget.ShedTriggerEnvelope;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;
import cz.cuni.pogamut.shed.widget.ShedWidgetColors;
import cz.cuni.pogamut.shed.widget.SlotEnvelope;
import java.awt.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

public class ShedWidgetFactory {
    protected static final int HORIZONTAL_GAP = 30;
    protected static final int VERTICAL_GAP = 10;
    private final ShedScene lapScene;
    private final IPresenterFactory presenterFactory;
    private final PoshPlan plan;

    ShedWidgetFactory(ShedScene scene, PoshPlan plan, IPresenterFactory presenterFactory) {
        this.plan = plan;
        this.lapScene = scene;
        this.presenterFactory = presenterFactory;
    }

    public ShedSenseWidget createSenseWidget(LapPath sensePath, Sense sense, LapChain parentChain) {
        assert (sensePath.traversePath(this.plan) == sense);
        ShedSenseWidget senseWidget = new ShedSenseWidget(this.lapScene, sense, ShedWidgetColors.SENSE.getColor());
        LapChain senseChain = parentChain.derive((PoshElement)sense);
        IPresenter sensePresenter = this.presenterFactory.createSensePresenter(sensePath, sense, senseWidget, senseChain);
        this.attachPresenterToWidget(senseWidget, sensePresenter, sense);
        return senseWidget;
    }

    private <TRIGGER_PARENT extends PoshElement> ShedCreationContainer<ShedTriggerEnvelope> createTriggerEnvelope(LapPath parentPath, TRIGGER_PARENT parent, Anchor firstSenseAnchor, Trigger<TRIGGER_PARENT> trigger, LapChain chain) {
        assert (parentPath.traversePath(this.plan) == parent);
        ShedTriggerEnvelope envelope = new ShedTriggerEnvelope(this.lapScene, firstSenseAnchor);
        IPresenter triggerPresenter = this.presenterFactory.createTriggerPresenter(parent, trigger, envelope, chain);
        triggerPresenter.register();
        ShedCreationContainer<ShedTriggerEnvelope> creationContainer = new ShedCreationContainer<ShedTriggerEnvelope>(envelope);
        Anchor sourceAnchor = firstSenseAnchor;
        int senseId = 0;
        for (Sense triggerSense : trigger) {
            LapPath sensePath = parentPath.concat(LapType.SENSE, senseId++);
            ShedSenseWidget senseWidget = this.createSenseWidget(sensePath, triggerSense, chain);
            envelope.add(senseWidget);
            ArrowWidget arrowWidget = new ArrowWidget(this.lapScene, sourceAnchor, senseWidget.getCommonAnchor());
            creationContainer.addArrow(arrowWidget);
            sourceAnchor = senseWidget.getCommonAnchor();
        }
        return creationContainer;
    }

    public ShedCreationContainer<AttachmentEnvelope> createAttachmentEnvelope(LapPath actionPath, TriggeredAction action, LapChain chain) {
        assert (actionPath.traversePath(this.plan) == action);
        String actionName = action.getName();
        if (this.plan.isAP(actionName)) {
            ActionPattern actionPattern = this.plan.getAP(actionName);
            ShedVariableWidget actionPatternWidget = new ShedVariableWidget(this.lapScene, actionName, ShedWidgetColors.ACTION_PATTERN.getColor());
            LapChain apChain = chain.derive(action, (PoshElement)actionPattern);
            int actionPatternId = this.plan.getActionPatternId(actionPattern);
            LapPath actionPatternPath = actionPath.concat(LapType.ACTION_PATTERN, actionPatternId);
            IPresenter apPresenter = this.presenterFactory.createActionPatternPresenter(actionPatternPath, action, actionPattern, actionPatternWidget, apChain);
            this.attachPresenterToWidget(actionPatternWidget, apPresenter, action);
            RightWidgetAnchor rightAPAnchor = new RightWidgetAnchor(actionPatternWidget);
            ShedCreationContainer<ShedActionsEnvelope> actionsContainer = this.createActionsEnvelope(actionPatternPath, actionPattern, rightAPAnchor, apChain);
            AttachmentEnvelope actionPatternEnvelope = new AttachmentEnvelope(this.lapScene);
            actionPatternEnvelope.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)30));
            actionPatternEnvelope.addChild(actionPatternWidget);
            actionPatternEnvelope.addChild(actionsContainer.getWidget());
            ShedCreationContainer<AttachmentEnvelope> actionPatternContainer = new ShedCreationContainer<AttachmentEnvelope>(actionPatternEnvelope);
            actionPatternContainer.addArrows(actionsContainer.getArrows());
            return actionPatternContainer;
        }
        if (this.plan.isC(actionName)) {
            Competence competence = this.plan.getC(actionName);
            ShedVariableWidget competenceWidget = new ShedVariableWidget(this.lapScene, competence.getName(), ShedWidgetColors.COMPETENCE.getColor());
            LapChain competenceChain = chain.derive(action, (PoshElement)competence);
            int competenceId = this.plan.getCompetenceId(competence);
            LapPath competencePath = actionPath.concat(LapType.COMPETENCE, competenceId);
            IPresenter competencePresenter = this.presenterFactory.createCompetencePresenter(competencePath, action, competence, competenceWidget, competenceChain);
            this.attachPresenterToWidget(competenceWidget, competencePresenter, action);
            RightWidgetAnchor rightCompetenceAnchor = new RightWidgetAnchor(competenceWidget);
            ShedCreationContainer<ShedChoicesEnvelope> choicesContainer = this.createChoicesEnvelope(competencePath, competence, rightCompetenceAnchor, competenceChain);
            AttachmentEnvelope competenceEnvelope = new AttachmentEnvelope(this.lapScene);
            competenceEnvelope.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.LEFT_TOP, (int)30));
            competenceEnvelope.addChild(competenceWidget);
            competenceEnvelope.addChild(choicesContainer.getWidget());
            ShedCreationContainer<AttachmentEnvelope> competenceContainer = new ShedCreationContainer<AttachmentEnvelope>(competenceEnvelope);
            competenceContainer.addArrows(choicesContainer.getArrows());
            return competenceContainer;
        }
        ShedVariableWidget actionWidget = new ShedVariableWidget(this.lapScene, actionName, ShedWidgetColors.ACTION.getColor());
        LapChain actionChain = chain.derive((PoshElement)action);
        IPresenter actionPresenter = this.presenterFactory.createActionPresenter(actionPath, action, actionWidget, actionChain);
        this.attachPresenterToWidget(actionWidget, actionPresenter, action);
        AttachmentEnvelope actionAttachment = new AttachmentEnvelope(this.lapScene);
        actionAttachment.addChild(actionWidget);
        return new ShedCreationContainer<AttachmentEnvelope>(actionAttachment);
    }

    private <LAP_ELEMENT extends PoshElement> void attachPresenterToWidget(Widget widget, IPresenter presenter, LAP_ELEMENT element) {
        WidgetAction editAction = presenter.getEditAction();
        if (editAction != null) {
            widget.getActions().addAction(editAction);
        }
        widget.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)ActionFactory.createFreeMoveStrategy(), new DragAndDropMoveProvider<LAP_ELEMENT>(this.lapScene, widget, element)));
        AbstractAcceptAction[] acceptActions = presenter.getAcceptProviders();
        if (acceptActions != null) {
            for (AbstractAcceptAction acceptAction : acceptActions) {
                widget.getActions().addAction(ActionFactory.createAcceptAction((AcceptProvider)acceptAction));
            }
        }
        presenter.register();
    }

    private ShedCreationContainer<ShedChoicesEnvelope> createChoicesEnvelope(LapPath competencePath, Competence competence, Anchor sourceAnchor, LapChain chain) {
        assert (competencePath.traversePath(this.plan) == competence);
        ShedChoicesEnvelope choicesEnvelope = new ShedChoicesEnvelope(this.lapScene, sourceAnchor);
        IPresenter choicesPresenter = this.presenterFactory.createChoicesPresenter(competencePath, competence, choicesEnvelope, chain);
        choicesPresenter.register();
        ShedCreationContainer<ShedChoicesEnvelope> choicesContainer = new ShedCreationContainer<ShedChoicesEnvelope>(choicesEnvelope);
        int choiceId = 0;
        for (CompetenceElement choice : competence.getChildDataNodes()) {
            LapPath choicePath = competencePath.concat(LapType.COMPETENCE_ELEMENT, choiceId++);
            ShedCreationContainer<SlotEnvelope> choiceContainer = this.createChoiceEnvelope(choicePath, choice, sourceAnchor, chain);
            choicesEnvelope.add(choiceContainer.getWidget());
            choicesContainer.addArrows(choiceContainer.getArrows());
        }
        return choicesContainer;
    }

    private ShedCreationContainer<ShedActionsEnvelope> createActionsEnvelope(LapPath actionPatternPath, ActionPattern actionPattern, Anchor sourceAnchor, LapChain actionPatterChain) {
        assert (actionPatternPath.traversePath(this.plan) == actionPattern);
        ShedActionsEnvelope actionsEnvelope = new ShedActionsEnvelope(this.lapScene, sourceAnchor);
        IPresenter actionsPresenter = this.presenterFactory.createActionsPresenter(actionPatternPath, actionPattern, actionsEnvelope, actionPatterChain);
        actionsPresenter.register();
        ShedCreationContainer<ShedActionsEnvelope> actionsContainer = new ShedCreationContainer<ShedActionsEnvelope>(actionsEnvelope);
        int actionId = 0;
        for (TriggeredAction action : actionPattern.getActions()) {
            LapPath actionPath = actionPatternPath.concat(LapType.ACTION, actionId++);
            ShedCreationContainer<ExpandedActionEnvelope> expandedActionContainer = this.createdExpandedActionEnvelope(actionPath, action, actionPatterChain);
            actionsEnvelope.add(expandedActionContainer.getWidget());
            actionsContainer.addArrows(expandedActionContainer.getArrows());
            Anchor expandedActionAnchor = expandedActionContainer.getWidget().getAnchor();
            ArrowWidget arrowToParent = new ArrowWidget(this.lapScene, sourceAnchor, expandedActionAnchor);
            actionsContainer.addArrow(arrowToParent);
        }
        return actionsContainer;
    }

    ShedScene getScene() {
        return this.lapScene;
    }

    ShedCollapseWidget createDriveWidget(LapPath drivePath, DriveElement drive) {
        assert (drivePath.traversePath(this.plan) == drive);
        ShedCollapseWidget driveWidget = new ShedCollapseWidget(this.lapScene, drive.getName(), ShedWidgetColors.DRIVE.getColor());
        IPresenter drivePresenter = this.presenterFactory.createDrivePresenter(drivePath, drive, driveWidget);
        this.attachPresenterToWidget(driveWidget, drivePresenter, drive);
        return driveWidget;
    }

    ShedCollapseWidget createChoiceWidget(LapPath choicePath, CompetenceElement choice) {
        assert (choicePath.traversePath(this.plan) == choice);
        ShedCollapseWidget choiceWidget = new ShedCollapseWidget(this.lapScene, choice.getName(), ShedWidgetColors.CHOICE.getColor());
        IPresenter choicePresenter = this.presenterFactory.createChoicePresenter(choicePath, choice, choiceWidget);
        this.attachPresenterToWidget(choiceWidget, choicePresenter, choice);
        return choiceWidget;
    }

    public ShedCreationContainer<ExpandedActionEnvelope> createdExpandedActionEnvelope(LapPath actionPath, TriggeredAction action, LapChain chain) {
        assert (actionPath.traversePath(this.plan) == action);
        ShedCreationContainer<AttachmentEnvelope> attachmentContainer = this.createAttachmentEnvelope(actionPath, action, chain);
        ExpandedActionEnvelope expandedAction = new ExpandedActionEnvelope(this.lapScene, attachmentContainer.getWidget());
        IPresenter expandedActionPresenter = this.presenterFactory.createExpandedActionPresenter(action, expandedAction, chain);
        expandedActionPresenter.register();
        ShedCreationContainer<ExpandedActionEnvelope> expandedActionContainer = new ShedCreationContainer<ExpandedActionEnvelope>(expandedAction);
        expandedActionContainer.addArrows(attachmentContainer.getArrows());
        return expandedActionContainer;
    }

    public ShedCreationContainer<SlotEnvelope> createDriveEnvelope(LapPath drivePath, DriveElement drive) {
        ShedCollapseWidget driveWidget = this.createDriveWidget(drivePath, drive);
        LeveledHorizontalAnchor driveAnchor = new LeveledHorizontalAnchor(driveWidget);
        ShedCreationContainer<ShedTriggerEnvelope> driveTriggerContainer = this.createTriggerEnvelope(drivePath, drive, driveAnchor, drive.getTrigger(), new LapChain());
        LapChain driveChain = new LapChain();
        LapPath driveActionPath = drivePath.concat(LapType.ACTION, 0);
        ShedCreationContainer<ExpandedActionEnvelope> expandedActionEnvelope = this.createdExpandedActionEnvelope(driveActionPath, drive.getAction(), driveChain);
        SlotEnvelope driveEnvelope = new SlotEnvelope(this.lapScene, driveWidget, driveTriggerContainer.getWidget(), expandedActionEnvelope.getWidget());
        ShedCreationContainer<SlotEnvelope> driveContainer = new ShedCreationContainer<SlotEnvelope>(driveEnvelope);
        driveContainer.addArrows(driveTriggerContainer.getArrows());
        ShedWidgetFactory.addCollapseAction(driveWidget, expandedActionEnvelope);
        return driveContainer;
    }

    public ShedCreationContainer<SlotEnvelope> createChoiceEnvelope(LapPath choicePath, CompetenceElement choice, Anchor sourceAnchor, LapChain competenceChain) {
        ShedCollapseWidget choiceWidget = this.createChoiceWidget(choicePath, choice);
        FixedWidgetAnchor rightChoiceAnchor = new FixedWidgetAnchor(choiceWidget, new Point(240, 15), Anchor.Direction.RIGHT);
        ShedCreationContainer<ShedTriggerEnvelope> choiceTriggerContainer = this.createTriggerEnvelope(choicePath, choice, rightChoiceAnchor, choice.getTrigger(), competenceChain);
        LapPath choiceActionPath = choicePath.concat(LapType.ACTION, 0);
        ShedCreationContainer<ExpandedActionEnvelope> expandedActionEnvelope = this.createdExpandedActionEnvelope(choiceActionPath, choice.getAction(), competenceChain);
        SlotEnvelope choiceEnvelope = new SlotEnvelope(this.lapScene, choiceWidget, choiceTriggerContainer.getWidget(), expandedActionEnvelope.getWidget());
        ShedCreationContainer<SlotEnvelope> choiceContainer = new ShedCreationContainer<SlotEnvelope>(choiceEnvelope);
        FixedWidgetAnchor leftChoiceAnchor = new FixedWidgetAnchor(choiceWidget, new Point(0, 15), Anchor.Direction.LEFT);
        ArrowWidget arrowToSource = new ArrowWidget(this.lapScene, sourceAnchor, leftChoiceAnchor);
        choiceContainer.addArrow(arrowToSource);
        choiceContainer.addArrows(choiceTriggerContainer.getArrows());
        choiceContainer.addArrows(expandedActionEnvelope.getArrows());
        ShedWidgetFactory.addCollapseAction(choiceWidget, expandedActionEnvelope);
        return choiceContainer;
    }

    private static void addCollapseAction(ShedCollapseWidget widget, ShedCreationContainer<ExpandedActionEnvelope> envelope) {
        widget.getActions().addAction(0, (WidgetAction)new CollapseAction(envelope));
    }

    private static class CollapseAction
    extends WidgetAction.Adapter {
        private final ShedCreationContainer<ExpandedActionEnvelope> envelope;

        private CollapseAction(ShedCreationContainer<ExpandedActionEnvelope> envelope) {
            this.envelope = envelope;
        }

        public WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
            boolean clickedOnTriangle;
            Point localPoint = event.getPoint();
            boolean bl = clickedOnTriangle = localPoint.x > 210;
            if (event.getButton() == 1 && clickedOnTriangle) {
                boolean isEnvelopeVisible = this.envelope.getWidget().isVisible();
                ShedCollapseWidget collapsableWidget = (ShedCollapseWidget)widget;
                collapsableWidget.setCollapsed(isEnvelopeVisible);
                this.envelope.getWidget().setVisible(!isEnvelopeVisible);
                Set<Widget> envelopeSubtree = this.getSubtreeWidgets(this.envelope.getWidget());
                ShedScene scene = (ShedScene)this.envelope.getWidget().getScene();
                List<Widget> arrows = scene.findArrows(envelopeSubtree);
                for (Widget arrow : arrows) {
                    arrow.setVisible(!isEnvelopeVisible);
                }
                scene.update();
                return WidgetAction.State.CONSUMED;
            }
            return WidgetAction.State.REJECTED;
        }

        private Set<Widget> getSubtreeWidgets(Widget subroot) {
            HashSet<Widget> allChildren = new HashSet<Widget>();
            allChildren.add(subroot);
            for (Widget child : subroot.getChildren()) {
                allChildren.addAll(this.getSubtreeWidgets(child));
            }
            return allChildren;
        }
    }
}

