package cz.cuni.pogamut.shed.widget;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

/**
 * {@link ShedWidget} that allows user to display little triangle on the right
 * side. The triangle indicates if it is collapsed or not. It used for drive and
 * choice.
 *
 * @author Honza
 */
class ShedCollapseWidget extends ShedVariableWidget {
    /**
     * What is the width of the triangle.
     */
    public static final int TRIANGLE_WIDTH = ShedWidget.height;

    /**
     * Does triangle point up (expanded) or down (collapsed)
     */
    private boolean collapsed = false;
    
    public ShedCollapseWidget(ShedScene scene, String displayName, Color color) {
        super(scene, displayName, color);
    }
    
    @Override
    protected void paintWidget() {
        super.paintWidget();
        Graphics2D g = getGraphics();
        g.setColor(color);
        Rectangle clientArea = getClientArea();
//        g.fillRect(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        
        Color darkerColor = color.darker();
        
        g.setColor(darkerColor);
        int[] xPoints = { 
            clientArea.x + clientArea.width - TRIANGLE_WIDTH, 
            clientArea.x + clientArea.width, 
            clientArea.x + clientArea.width - TRIANGLE_WIDTH/2 
        }; 
        if (collapsed) {
            int[] yPoints = { 
                clientArea.y, 
                clientArea.y, 
                clientArea.y + clientArea.height 
            };
            g.fillPolygon(xPoints, yPoints, 3);
        } else {
            int[] yPoints = { 
                clientArea.y + clientArea.height, 
                clientArea.y + clientArea.height, 
                clientArea.y 
            };
            g.fillPolygon(xPoints, yPoints, 3);
        }
        
        
//        drawString(g, font, getForeground(), getDisplayName());
    }

    void setCollapsed(boolean newCollapsed) {
        this.collapsed = newCollapsed;
        // request revalidation for repainting only
        revalidate(true);
    }
    
}
