package cz.cuni.pogamut.posh.explorer;

import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;

/**
 * Special cralwer listener that will collect all name mappings and pass them to
 * the {@link ShedPresenter}.
 *
 * @author Honza
 */
public class NameMapCrawler implements CrawlerListener<PrimitiveData> {

    private final ShedPresenter presenter;
    private Set<PrimitiveData> crawledNames = new HashSet<PrimitiveData>();

    public NameMapCrawler(ShedPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void started(Crawler<PrimitiveData> crawler) {
        assert SwingUtilities.isEventDispatchThread();

        // Clear the mapping
        for (PrimitiveData record : crawledNames) {
            String key = record.classFQN;
            presenter.setNameMapping(key, null);
        }
        crawledNames.clear();
    }

    @Override
    public void crawledData(Crawler<PrimitiveData> crawler, Collection<PrimitiveData> data) {
        assert SwingUtilities.isEventDispatchThread();

        crawledNames.addAll(data);

        for (PrimitiveData record : data) {
            String key = record.classFQN;

            presenter.setNameMapping(key, record);
        }
    }

    @Override
    public void finished(Crawler<PrimitiveData> crawler, boolean error) {
        assert SwingUtilities.isEventDispatchThread();
    }
}
