/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;

class TableArgument {
    private String name;
    private String valueString;

    public TableArgument(String name, Object value) {
        this.name = name;
        this.valueString = Result.toLap((Object)value);
    }

    public TableArgument(Arguments.Argument arg) {
        this.name = arg.getParameterName();
        this.valueString = arg.getParameterVariable() != null ? arg.getParameterVariable() : Result.toLap((Object)arg.getValue());
    }

    public String getName() {
        return this.name;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String newValueString) throws ParseException {
        if (!Result.isVariableName((String)newValueString)) {
            Result.parseValue((String)newValueString);
        }
        this.valueString = newValueString;
    }

    public Arguments.Argument createArgument() {
        if (this.stringRepresentsVariable(this.valueString)) {
            return Arguments.Argument.createVariableArgument((String)this.name, (String)this.valueString);
        }
        try {
            Object value = Result.parseValue((String)this.valueString);
            return Arguments.Argument.createValueArgument((String)this.name, (Object)value);
        }
        catch (ParseException ex) {
            throw new FubarException("valueString should always be parsable", (Throwable)ex);
        }
    }

    private boolean stringRepresentsVariable(String s) {
        return s.startsWith("$");
    }

    void setName(String newName) {
        this.name = newName;
    }
}

