/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;

public class ShedVariableWidget
extends ShedWidget {
    private List<String> present = new LinkedList<String>();
    private List<String> missing = new LinkedList<String>();
    private List<String> unused = new LinkedList<String>();
    private static final Font titleFont = new Font("Helvetica", 1, 16);
    private static final Font presentFont = new Font("Helvetica", 1, 12);
    private static final Font missingFont = new Font("Helvetica", 1, 12);
    private static final Font unusedFont = new Font("Helvetica", 2, 12);
    private int intensity = 0;
    private static int BORDER_WIDTH = 4;
    private ShowBreakpoint showBreakpointStrip = ShowBreakpoint.NONE;
    static final int BREAKPOINT_STRIP_WIDTH = 10;

    public ShedVariableWidget(ShedScene scene, String title, Color color) {
        super(scene, title, color);
        this.setPreferredBounds(null);
        this.setMinimumSize(new Dimension(240, 30));
    }

    public final void setPresent(List<String> newPresent) {
        this.present.clear();
        this.present.addAll(newPresent);
        this.revalidate();
    }

    public final void setMissing(List<String> newPresent) {
        this.missing.clear();
        this.missing.addAll(newPresent);
        this.revalidate();
    }

    public final void setUnused(List<String> newPresent) {
        this.unused.clear();
        this.unused.addAll(newPresent);
        this.revalidate();
    }

    protected Rectangle calculateClientArea() {
        int unusedLinesWidth;
        int missingLinesWidth;
        Graphics2D gr = this.getGraphics();
        if (gr == null) {
            throw new IllegalStateException("Trying to compute client area without graphics2D.");
        }
        FontMetrics titleFontMetrics = gr.getFontMetrics(titleFont);
        FontMetrics boldFontMetrics = gr.getFontMetrics(presentFont);
        FontMetrics plainFontMetrics = gr.getFontMetrics(missingFont);
        FontMetrics italicFontMetrics = gr.getFontMetrics(unusedFont);
        Rectangle2D titleBounds = titleFontMetrics.getStringBounds(this.getDisplayName(), gr);
        Rectangle rectangle = ShedVariableWidget.roundRectangle(titleBounds);
        rectangle.x = 0;
        rectangle.y = 0;
        int widgetWidth = rectangle.width;
        int presentLinesWidth = this.getLinesWidth(this.present, boldFontMetrics, gr);
        if (widgetWidth < presentLinesWidth) {
            widgetWidth = presentLinesWidth;
        }
        if (widgetWidth < (missingLinesWidth = this.getLinesWidth(this.missing, plainFontMetrics, gr))) {
            widgetWidth = missingLinesWidth;
        }
        if (widgetWidth < (unusedLinesWidth = this.getLinesWidth(this.unused, italicFontMetrics, gr))) {
            widgetWidth = unusedLinesWidth;
        }
        widgetWidth += titleFontMetrics.getMaxAdvance();
        widgetWidth += 4;
        rectangle.width = 240;
        int widgetHeight = titleFontMetrics.getHeight();
        widgetHeight += boldFontMetrics.getHeight() * this.present.size();
        widgetHeight += plainFontMetrics.getHeight() * this.missing.size();
        widgetHeight += italicFontMetrics.getHeight() * this.unused.size();
        rectangle.height = widgetHeight += italicFontMetrics.getDescent() * 2;
        return rectangle;
    }

    private static Rectangle roundRectangle(Rectangle2D rectangle) {
        int x1 = (int)Math.floor(rectangle.getX());
        int y1 = (int)Math.floor(rectangle.getY());
        int x2 = (int)Math.ceil(rectangle.getMaxX());
        int y2 = (int)Math.ceil(rectangle.getMaxY());
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    int getTitleWidth(FontMetrics fontMetrics, Graphics gr) {
        Rectangle2D titleBounds = fontMetrics.getStringBounds(this.getDisplayName(), gr);
        Rectangle rectangle = ShedVariableWidget.roundRectangle(titleBounds);
        return rectangle.width;
    }

    int getLinesWidth(List<String> lines, FontMetrics fontMetrics, Graphics gr) {
        int linesWidth = 0;
        for (String line : lines) {
            Rectangle lineBounds = ShedVariableWidget.roundRectangle(fontMetrics.getStringBounds(line, gr));
            int lineWidth = lineBounds.width;
            if (lineWidth <= linesWidth) continue;
            linesWidth = lineWidth;
        }
        return linesWidth;
    }

    public void setActiveIntensity(int percent) {
        this.intensity = percent;
        this.repaint();
    }

    @Override
    protected void paintWidget() {
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.color);
        Rectangle clientArea = this.getClientArea();
        if (this.intensity > 0) {
            Color fullColor = Color.RED;
            Color borderColor = new Color(this.color.getRed() + (fullColor.getRed() * this.intensity - this.color.getRed() * this.intensity) / 100, this.color.getGreen() + (fullColor.getGreen() * this.intensity - this.color.getGreen() * this.intensity) / 100, this.color.getBlue() + (fullColor.getBlue() * this.intensity - this.color.getBlue() * this.intensity) / 100);
            gr.setColor(borderColor);
            gr.fillRect(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            gr.setColor(this.color);
            gr.fillRect(clientArea.x + BORDER_WIDTH, clientArea.y + BORDER_WIDTH, clientArea.width - 2 * BORDER_WIDTH, clientArea.height - 2 * BORDER_WIDTH);
        } else {
            gr.setColor(this.color);
            gr.fillRect(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        }
        if (this.showBreakpointStrip != ShowBreakpoint.NONE) {
            gr.setColor(this.showBreakpointStrip.getColor());
            gr.fillRect(clientArea.width - 10, clientArea.y, 10, clientArea.height);
        }
        int x = 4;
        int y = 0;
        FontMetrics titleFontMetrics = gr.getFontMetrics(titleFont);
        FontMetrics boldFontMetrics = gr.getFontMetrics(presentFont);
        FontMetrics plainFontMetrics = gr.getFontMetrics(missingFont);
        FontMetrics italicFontMetrics = gr.getFontMetrics(unusedFont);
        gr.setColor(Color.BLACK);
        y = titleFontMetrics.getLeading() + titleFontMetrics.getAscent();
        gr.setFont(titleFont);
        this.drawFittingString(x, y, this.getDisplayName(), gr, titleFontMetrics);
        y += titleFontMetrics.getHeight();
        gr.setFont(presentFont);
        for (String presentLine : this.present) {
            this.drawFittingString(x, y, presentLine, gr, boldFontMetrics);
            y += boldFontMetrics.getHeight();
        }
        gr.setColor(Color.RED);
        gr.setFont(missingFont);
        for (String missingLine : this.missing) {
            this.drawFittingString(x, y, missingLine, gr, plainFontMetrics);
            y += plainFontMetrics.getHeight();
        }
        gr.setColor(Color.BLACK);
        gr.setFont(unusedFont);
        for (String missingLine : this.unused) {
            this.drawFittingString(x, y, missingLine, gr, italicFontMetrics);
            y += italicFontMetrics.getHeight();
        }
    }

    private void drawFittingString(int x, int y, String text, Graphics2D gr, FontMetrics fm) {
        AffineTransform originalTransform = gr.getTransform();
        gr.translate(x, y);
        String fittingText = this.getFittingString(text, fm, 240);
        gr.drawString(fittingText, 0, 0);
        gr.setTransform(originalTransform);
    }

    public void addBreakpoint(boolean single) {
        this.showBreakpointStrip = single ? ShowBreakpoint.SINGLE : ShowBreakpoint.PERMANENT;
        this.repaint();
    }

    public void removeBreakpoint() {
        this.showBreakpointStrip = ShowBreakpoint.NONE;
        this.repaint();
    }

    static enum ShowBreakpoint {
        NONE(Color.WHITE),
        SINGLE(new Color(240, 72, 72)),
        PERMANENT(new Color(178, 15, 15));

        private final Color color;

        private ShowBreakpoint(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

