/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.view;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

class TreeModificationListener
implements PoshElementListener {
    private final PoshPlan lapTree;
    private final StyledDocument document;
    private int balance = 0;

    public TreeModificationListener(PoshPlan lapTree, StyledDocument document) {
        this.lapTree = lapTree;
        this.document = document;
    }

    public void register() {
        this.registerBranch((PoshElement<?, ?>)this.lapTree, true);
    }

    public void unregister() {
        this.registerBranch((PoshElement<?, ?>)this.lapTree, false);
        if (this.balance != 0) {
            String message = MessageFormat.format("Balance of register/unregister pairs for global listener is {0}, should be 0. If you can reproduce, report.", this.balance);
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    private void registerElement(PoshElement element, boolean register) {
        if (register) {
            element.addElementListener((PoshElementListener)this);
            ++this.balance;
        } else {
            element.removeElementListener((PoshElementListener)this);
            --this.balance;
        }
    }

    private void registerBranch(PoshElement<?, ?> branchRoot, boolean register) {
        this.registerElement(branchRoot, register);
        for (PoshElement child : branchRoot.getChildDataNodes()) {
            this.registerBranch(child, register);
        }
    }

    public void childElementAdded(PoshElement parent, PoshElement child) {
        this.registerBranch(child, true);
        this.notifyTreeModified();
    }

    public void childElementMoved(PoshElement parent, PoshElement child, int oldIndex, int newIndex) {
        this.notifyTreeModified();
    }

    public void childElementRemoved(PoshElement parent, PoshElement child, int removedChildPosition) {
        this.registerBranch(child, false);
        this.notifyTreeModified();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.notifyTreeModified();
    }

    private void notifyTreeModified() {
        try {
            this.document.remove(0, this.document.getLength());
            this.document.insertString(0, this.lapTree.toString(), null);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

