/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableParameterTest
extends Assert {
    private TableParameter stringParameter;
    private TableParameter nilParameter;
    private TableParameter intParameter;
    private TableParameter boolParameter;
    private TableParameter overridenValue;
    private TableParameter overridenVariable;

    @Before
    public void setUp() {
        this.overridenValue = new TableParameter("$overridenValueParam", "\"original\"", "\"overriden\"");
        this.overridenVariable = new TableParameter("$overridenVariableParam", "\"original\"", "$overriding");
        this.stringParameter = new TableParameter("$stringParam", "\"Hello\"", "");
        this.nilParameter = new TableParameter("$nilParam", "nil", "");
        this.intParameter = new TableParameter("$intParam", "15", "");
        this.boolParameter = new TableParameter("$boolParam", "true", "");
    }

    @Test
    public void stringParam() {
        TableParameterTest.assertEquals((Object)"Hello", (Object)this.stringParameter.getDefaultValue());
    }

    @Test
    public void nilParam() {
        TableParameterTest.assertEquals(null, (Object)this.nilParameter.getDefaultValue());
    }

    @Test
    public void intParam() {
        TableParameterTest.assertEquals((Object)15, (Object)this.intParameter.getDefaultValue());
    }

    @Test
    public void boolParam() {
        TableParameterTest.assertEquals((Object)true, (Object)this.boolParameter.getDefaultValue());
    }

    @Test
    public void overridenValueParamArgument() {
        Arguments.Argument argument = this.overridenValue.createOverrideArgument();
        TableParameterTest.assertEquals((Object)"$overridenValueParam", (Object)argument.getParameterName());
        TableParameterTest.assertNull((Object)argument.getParameterVariable());
        TableParameterTest.assertEquals((Object)"overriden", (Object)argument.getValue());
    }

    @Test
    public void overridenVariableParamArgument() {
        Arguments.Argument argument = this.overridenVariable.createOverrideArgument();
        TableParameterTest.assertEquals((Object)"$overridenVariableParam", (Object)argument.getParameterName());
        TableParameterTest.assertEquals((Object)"$overriding", (Object)argument.getParameterVariable());
    }
}

