/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Token;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptSense2Sense;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.NamedBasicWidget;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class SimpleSenseWidget
extends NamedBasicWidget<Sense> {
    public static final String DEFAULT_FAIL_SENSE = "cz.cuni.amis.pogamut.sposh.ut2004.senses.Fail";
    public static final String DEFAULT_SUCCEED_SENSE = "cz.cuni.amis.pogamut.sposh.ut2004.senses.Succeed";

    SimpleSenseWidget(PoshScene scene, Sense dataNode, PoshWidget<? extends PoshElement> parent) {
        super(scene, dataNode, parent);
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new SenseInplaceEditor(dataNode)));
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        throw new RuntimeException("This should never be called. No children expected");
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        int numSenses = ((Sense)this.getDataNode()).getParent().getNumberOfChildInstances(Sense.class);
        if (numSenses > 1) {
            list.add(new DeleteNodeAction("Delete sense", this.getDataNode()));
        }
        return list;
    }

    @Override
    public String getHeadlineText() {
        String name = this.getPoshScene().getSensesFQNMapping().get(((Sense)this.getDataNode()).getName());
        if (name == null) {
            name = ((Sense)this.getDataNode()).getName();
        }
        if (((Sense)this.getDataNode()).getPredicate() != null) {
            if (((Sense)this.getDataNode()).getPredicate() == Sense.Predicate.DEFAULT && ((Sense)this.getDataNode()).getOperand() != null && ((Sense)this.getDataNode()).getOperand() == Boolean.TRUE) {
                return name;
            }
            name = name + " " + ((Sense)this.getDataNode()).getPredicate().toString() + " " + ((Sense)this.getDataNode()).getValueString();
        }
        return name;
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.SENSE;
    }

    @Override
    public void elementPropertyChange(PropertyChangeEvent evt) {
        Sense sense = (Sense)evt.getSource();
        this.setHeadlineText(sense.getRepresentation());
        this.doRepaint();
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptSense2Sense((Sense)this.getDataNode()));
        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection senseNameProp = new PropertySupport.Reflection(this.getDataNode(), String.class, "getSenseName", "setSenseName");
            senseNameProp.setName("paSenseName");
            senseNameProp.setDisplayName("Name of the sense");
            senseNameProp.setShortDescription("In this field can be act, sense or competence node");
            PropertySupport.Reflection predicateProp = new PropertySupport.Reflection(this.getDataNode(), Integer.class, "getPredicateIndex", "setPredicateIndex");
            predicateProp.setName("paPredicate");
            predicateProp.setDisplayName("Predicate(<, =, !=...)");
            predicateProp.setShortDescription("One od the following: == | = | != | < | > | <= | >= \nBoth '==' and '=' test for equality");
            int[] intValues = new int[Sense.Predicate.values().length];
            String[] stringKeys = new String[Sense.Predicate.values().length];
            for (int i = 0; i < Sense.Predicate.values().length; ++i) {
                intValues[i] = i;
                stringKeys[i] = Sense.Predicate.values()[i].toString();
            }
            predicateProp.setValue("intValues", (Object)intValues);
            predicateProp.setValue("stringKeys", (Object)stringKeys);
            PropertySupport.Reflection valueProp = new PropertySupport.Reflection(this.getDataNode(), String.class, "getValueString", "setValueString");
            valueProp.setName("paValue");
            valueProp.setDisplayName("Value");
            valueProp.setShortDescription("Value is used together with predicate, it is compared to the value returned from the act using predicate and that is the result of the act.");
            set.put(new Node.Property[]{senseNameProp, predicateProp, valueProp});
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    private static class SenseInplaceEditor
    implements TextFieldInplaceEditor {
        private final Sense sense;

        SenseInplaceEditor(Sense sense) {
            this.sense = sense;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.sense.getRepresentation();
        }

        public void setText(Widget widget, String string) {
            block7: {
                try {
                    PoshParser pp = new PoshParser((Reader)new StringReader(string));
                    Token nameToken = null;
                    Token secondToken = null;
                    Token thirdToken = null;
                    nameToken = pp.getNextToken();
                    if (nameToken.kind != 0) {
                        secondToken = pp.getNextToken();
                        if (secondToken.kind != 0) {
                            thirdToken = pp.getNextToken();
                            if (thirdToken.kind != 0) {
                                this.sense.setValueString(thirdToken.image.trim());
                                this.sense.setPredicate(Sense.Predicate.getPredicate((String)secondToken.image.trim()));
                                this.sense.setSenseName(nameToken.image.trim());
                            } else {
                                this.sense.setValueString(secondToken.image.trim());
                                this.sense.setPredicate(Sense.Predicate.DEFAULT);
                                this.sense.setSenseName(nameToken.image.trim());
                            }
                        } else {
                            this.sense.setSenseName(nameToken.image.trim());
                            this.sense.setPredicate(Sense.Predicate.DEFAULT);
                            this.sense.setOperand((Object)Boolean.TRUE);
                        }
                        break block7;
                    }
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

