/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.elements.Triggers;
import cz.cuni.amis.pogamut.sposh.exceptions.UnexpectedElementException;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptDrive2Drive;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.NamedBasicWidget;
import cz.cuni.pogamut.posh.widget.kidview.SimpleTriggersWidget;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

class SimpleDriveElementWidget
extends NamedBasicWidget<DriveElement> {
    SimpleDriveElementWidget(PoshScene scene, DriveElement associatedDataNode, PoshWidget<? extends PoshElement> parent) {
        super(scene, associatedDataNode, parent);
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new DriveInplaceEditor(associatedDataNode)));
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.DRIVE_ELEMENT;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        int numDrives = ((DriveElement)this.getDataNode()).getParent().getNumberOfChildInstances(DriveElement.class);
        if (numDrives > 1) {
            list.add(new DeleteNodeAction("Delete drive", this.getDataNode()));
        }
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof Triggers) {
            SimpleTriggersWidget triggersWidget = new SimpleTriggersWidget(this.getPoshScene(), (Triggers)dataNode, this);
            this.getChildNodes().add(triggersWidget);
            this.getPoshScene().addPoshWidget(triggersWidget, true);
        } else if (dataNode instanceof TriggeredAction) {
            this.addTriggeredActionWidgets((TriggeredAction)dataNode);
        } else {
            String msg = MessageFormat.format("Drive {0} got new child: {1} but no such class accepted.", ((DriveElement)this.getDataNode()).getName(), dataNode.getClass().getSimpleName());
            throw new UnexpectedElementException(msg);
        }
    }

    @Override
    public void elementPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("deName")) {
            this.setHeadlineText((String)evt.getNewValue());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptDrive2Drive((DriveElement)this.getDataNode()));
        return list;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection(this.getDataNode(), String.class, "getName", "setName");
            nameProp.setName("deName");
            nameProp.setDisplayName("Name of drive element");
            set.put(new Node.Property[]{nameProp});
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    protected static class DriveInplaceEditor
    implements TextFieldInplaceEditor {
        private DriveElement drive;

        protected DriveInplaceEditor(DriveElement drive) {
            this.drive = drive;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.drive.getName();
        }

        public void setText(Widget widget, String string) {
            try {
                this.drive.setDriveName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

