/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.PoshNodeType;
import cz.cuni.pogamut.posh.widget.PoshScene;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.accept.AcceptAP2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptComp2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptTA2TA;
import cz.cuni.pogamut.posh.widget.kidview.AbstractMenuAction;
import cz.cuni.pogamut.posh.widget.kidview.NamedBasicWidget;
import cz.cuni.pogamut.posh.widget.menuactions.AddTA2AP;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

public class SimpleRoleActionPatternWidget
extends NamedBasicWidget<TriggeredAction> {
    ActionPattern apNode;

    public SimpleRoleActionPatternWidget(PoshScene poshScene, TriggeredAction dataNode, PoshWidget<? extends PoshElement> parent, ActionPattern apNode) {
        super(poshScene, dataNode, parent);
        this.apNode = apNode;
        this.apNode.addElementListener((PoshElementListener)this);
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)new APInplaceEditor(dataNode, apNode)));
    }

    @Override
    protected PoshWidget.PropertyNode createPropertiesNode() {
        return new PoshWidget.PropertyNode((PoshElement)this.apNode, this);
    }

    public void regenerate() {
        this.deleteChildrenWidgets();
        this.createCh();
    }

    private void deleteChildrenWidgets() {
        for (PoshWidget<PoshElement> widget : this.getChildNodes()) {
            this.getPoshScene().deletePoshWidget(widget);
        }
    }

    private void createCh() {
        LinkedList<PoshWidget<? extends PoshElement>> fringe = new LinkedList<PoshWidget<? extends PoshElement>>(this.createWidgetChildren(this, (PoshElement)this.apNode));
        while (!fringe.isEmpty()) {
            PoshWidget headWidget = (PoshWidget)((Object)fringe.poll());
            Object headDataNode = headWidget.getDataNode();
            if (headDataNode instanceof TriggeredAction) continue;
            fringe.addAll(this.createWidgetChildren(headWidget, (PoshElement)headDataNode));
        }
    }

    private List<PoshWidget<? extends PoshElement>> createWidgetChildren(PoshWidget<? extends PoshElement> w, PoshElement dn) {
        List dataChildren = dn.getChildDataNodes();
        for (PoshElement dnch : dataChildren) {
            w.nodeChanged(PoshTreeEvent.NEW_CHILD_NODE, dnch);
        }
        return w.getChildNodes();
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.ACTION_PATTERN;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();
        list.add(new AddTA2AP(this.apNode));
        int numTAs = ((TriggeredAction)this.getDataNode()).getParent().getNumberOfChildInstances(TriggeredAction.class);
        if (numTAs > 1) {
            list.add(new DeleteNodeAction("Delete action", this.getDataNode()));
        }
        return list;
    }

    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (!(dataNode instanceof TriggeredAction)) {
            throw new RuntimeException("Child of this type not permitted: " + dataNode.getClass().getName());
        }
        this.addTriggeredActionWidgets((TriggeredAction)dataNode);
    }

    @Override
    public void elementPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("taName")) {
            this.changeTriggeredActionWidgets((TriggeredAction)this.getDataNode());
            this.doRepaint();
        }
        if (evt.getPropertyName().equals("apName")) {
            this.changeTriggeredActionWidgets((TriggeredAction)this.getDataNode());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        LinkedList<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();
        list.add(new AcceptTA2TA((TriggeredAction)this.getDataNode()));
        list.add(new AcceptAP2TA((TriggeredAction)this.getDataNode()));
        list.add(new AcceptComp2TA((TriggeredAction)this.getDataNode()));
        return list;
    }

    @Override
    protected void deleteWidgetFromScene(PoshElement dataNode) {
        super.deleteWidgetFromScene(dataNode);
        this.apNode.removeElementListener((PoshElementListener)this);
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        try {
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection((Object)this.apNode, String.class, "getNodeName", "setNodeName");
            nameProp.setName("apName");
            nameProp.setDisplayName("Name of action pattern");
            PropertySupport.Reflection commentProp = new PropertySupport.Reflection((Object)this.apNode, String.class, "getNodeComment", "setNodeComment");
            commentProp.setName("apComment");
            commentProp.setDisplayName("Comment about node");
            commentProp.setShortDescription("It is difficult to keep track about what part of POSH plan does what and that is where comments come in.");
            set.put(new Node.Property[]{nameProp, commentProp});
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return sheet;
    }

    protected static class APInplaceEditor
    implements TextFieldInplaceEditor {
        private TriggeredAction action;
        private ActionPattern ap;

        protected APInplaceEditor(TriggeredAction action, ActionPattern ap) {
            this.action = action;
            this.ap = ap;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.action.getName();
        }

        public void setText(Widget widget, String string) {
            String apName = this.ap.getName();
            String actionName = this.action.getName();
            try {
                this.ap.setName(string);
                this.action.setActionName(string);
            }
            catch (Exception ex) {
                try {
                    this.action.setActionName(actionName);
                    this.ap.setName(apName);
                }
                catch (Exception ex1) {
                    Exceptions.printStackTrace((Throwable)ex1);
                }
            }
        }
    }
}

