/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.palette.external;

import cz.cuni.amis.pogamut.sposh.SPOSHAction;
import cz.cuni.amis.pogamut.sposh.SPOSHSense;
import cz.cuni.pogamut.posh.PoshDataObject;
import cz.cuni.pogamut.posh.palette.PaletteRoot;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.palette.PaletteController;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class BehaviourInterfaceBuilder
implements Runnable {
    public final String behaviourInterfaceKey = "behaviour.interface.class";
    private Lookup lookup;

    public BehaviourInterfaceBuilder(Lookup lookup) {
        this.lookup = lookup;
    }

    @Override
    public void run() {
        PoshDataObject dataObj = (PoshDataObject)((Object)this.lookup.lookup(PoshDataObject.class));
        if (dataObj == null) {
            return;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)dataObj.getPrimaryFile());
        if (project == null) {
            return;
        }
        try {
            this.buildInterface(project);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BehaviourInterfaceBuilder.class.getName()).finest(ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(BehaviourInterfaceBuilder.class.getName()).finest(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getProjectProperty(Project project, String key) throws FileNotFoundException, IOException {
        FileObject propFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        if (propFile == null) {
            throw new FileNotFoundException("project.properties of project were not found.");
        }
        Properties projectProperties = new Properties();
        InputStream is = null;
        try {
            is = propFile.getInputStream();
            projectProperties.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String prop = projectProperties.getProperty(key);
        if (prop == null || prop.equals("")) {
            throw new IllegalArgumentException("Property specifing the behaviour interface (behaviour.interface.class) for project \"" + project + "\" is empty.");
        }
        return prop;
    }

    protected void buildInterface(Project project) throws FileNotFoundException, IOException {
        String behaviourInterface = this.getProjectProperty(project, "behaviour.interface.class");
        if (behaviourInterface == null) {
            throw new IllegalArgumentException("Property specifing the behaviour interface (behaviour.interface.class) for project \"" + project + "\" not found");
        }
        FileObject sourceDir = this.getSourceFolder(project);
        if (sourceDir == null) {
            throw new FileNotFoundException("Unable to find folder with sources for project \"" + project + "\"");
        }
        FileObject interfaceFile = this.createInterfaceFile(sourceDir, behaviourInterface);
        this.writeInterface(interfaceFile, behaviourInterface);
    }

    private boolean isSourceFolder(SourceGroup sg) {
        return sg.getDisplayName().contains("source") || sg.getDisplayName().contains("Source");
    }

    private FileObject getSourceFolder(Project project) {
        SourceGroup[] sourceGroups;
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sg : sourceGroups = sources.getSourceGroups("java")) {
            if (!this.isSourceFolder(sg)) continue;
            return sg.getRootFolder();
        }
        return null;
    }

    private FileObject createInterfaceFile(FileObject sourceDir, String behaviourInterface) throws IOException {
        System.out.println("Source " + sourceDir.getPath());
        String[] canonicalPath = behaviourInterface.split("\\.");
        FileObject packageDir = sourceDir;
        for (int i = 0; i < canonicalPath.length - 1; ++i) {
            FileObject nextPack = packageDir.getFileObject(canonicalPath[i]);
            if (nextPack == null) {
                System.out.println("Create " + canonicalPath[i]);
                packageDir = packageDir.createFolder(canonicalPath[i]);
                continue;
            }
            if (nextPack.isValid() && nextPack.isFolder()) {
                System.out.println("Traverse " + canonicalPath[i]);
                packageDir = nextPack;
                continue;
            }
            throw new IOException("Part of path to interface behaviour is file(or some other trouble): " + nextPack.getPath());
        }
        String filename = canonicalPath[canonicalPath.length - 1] + ".java";
        FileObject interfaceFile = packageDir.getFileObject(filename);
        if (interfaceFile != null) {
            return interfaceFile;
        }
        return packageDir.createData(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInterface(FileObject interfaceFile, String behaviourInterface) throws FileAlreadyLockedException, IOException {
        String[] splitInterfaceName = behaviourInterface.split("\\.");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(interfaceFile.getOutputStream());
            writer.write("/* DO NOT EDIT THIS FILE, IT IS AUTO-REGENERATED EVERY TIME THE PALETTE IS CHANGED */\n");
            if (splitInterfaceName.length > 1) {
                writer.write("package ");
                for (int i = 0; i < splitInterfaceName.length - 2; ++i) {
                    writer.write(splitInterfaceName[i] + ".");
                }
                writer.write(splitInterfaceName[splitInterfaceName.length - 2] + ";\n\n");
            }
            writer.write("import " + SPOSHAction.class.getCanonicalName() + ";\n");
            writer.write("import " + SPOSHSense.class.getCanonicalName() + ";\n\n");
            writer.write("public interface " + splitInterfaceName[splitInterfaceName.length - 1] + "{\n");
            for (String action : this.getActions()) {
                writer.write("\n    @SPOSHAction\n    public boolean " + action + "();");
            }
            for (String sense : this.getSenses()) {
                writer.write("\n    @SPOSHSense\n    public Object " + sense + "(String param);");
            }
            writer.write("\n}\n");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private List<String> getActions() {
        PaletteController paletteController = (PaletteController)this.lookup.lookup(PaletteController.class);
        if (paletteController == null) {
            throw new RuntimeException("Palette controller not present in the lookup.");
        }
        PaletteRoot pal = (PaletteRoot)((Object)paletteController.getRoot().lookup(PaletteRoot.class));
        if (pal == null) {
            throw new RuntimeException("Palette root not present in the palette controller.");
        }
        return pal.getActionsChildren().getUndefinedActions();
    }

    private List<String> getSenses() {
        PaletteController paletteController = (PaletteController)this.lookup.lookup(PaletteController.class);
        PaletteRoot pal = (PaletteRoot)((Object)paletteController.getRoot().lookup(PaletteRoot.class));
        return pal.getSensesChildren().getUndefinedSenses();
    }
}

