package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetencePriorityElement;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 * AcceptProvider for CompetencePriorityElement. When CompElem is dropped,
 * add it as a sibling above.
 */
public class AcceptCPE2CPE extends AbstractAcceptAction<CompetencePriorityElement> {

    public AcceptCPE2CPE(CompetencePriorityElement dataNode) {
        super(CompetencePriorityElement.dataFlavor, dataNode, null);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        CompetencePriorityElement cElement = (CompetencePriorityElement) tr.getTransferData(dataFlavor);
        if (cElement == null) {
            return;
        }

        Competence cNode = (Competence) dataNode.getParent();

        if (cNode == null) {
            return;
        }

        cNode.addCompetencePriorityElement(cElement);

        int newlyAddedCElementIndex =
                this.getIndexInList(cNode.getChildDataNodes(), cElement);

        // find index, where should dropped sense be =
        //    index of sense new sense was dropped on
        int assignedCElementIndex =
                this.getIndexInList(cNode.getChildDataNodes(), dataNode);

        int relativePositionChange =
                assignedCElementIndex - newlyAddedCElementIndex;


        /*			System.out.println("Index of newly dropped: " + newlyAddedCElementIndex);
        System.out.println("Index where should newly dropped be: " + assignedCElementIndex);
        System.out.println("Relative position change: " + relativePositionChange);

        for (PoshElement n : dataNode.getParent().getChildDataNodes()) {
        System.out.println("  DataNode " + n.getDisplayName());
        }
         */
        cNode.moveChild(cElement, relativePositionChange);
    }
}

