package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

/**
 * When competence is dropped to the triggered action, add competence to
 * the posh plan if it isn't already there and change name of triggered action
 * (that means triggered action will expand to the competence).
 *
 * @author Honza
 */
public class AcceptComp2TA extends AbstractAcceptAction<TriggeredAction> {

    public AcceptComp2TA(TriggeredAction dataNode) {
        super(Competence.dataFlavor, dataNode);
    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        // I am using duplicated function instead of transferable because
        // I want to have a immediate reaction to duplicate name of Competence
        Competence competenceNode = (Competence) tr.getTransferData(dataFlavor);
        if (competenceNode == null) {
            return;
        }
        PoshPlan root = dataNode.getRootNode();

        if (!root.getCompetences().contains(competenceNode)) {
            try {
                root.addCompetence(competenceNode);
            } catch (ParseException ex) {
                NotifyDescriptor.Message desc =
                        new NotifyDescriptor.Message(ex.getMessage());
                DialogDisplayer.getDefault().notify(desc);
                return;
            }
        }


        this.dataNode.setActionName(competenceNode.getNodeName());
    }
}
