package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

/**
 * Simplified base class for manipulating the structure of the tree through DnD.
 *
 * @author Honza
 */
public abstract class StrAbstractAcceptAction<ACCEPTOR extends PoshElement, DONOR extends PoshElement> extends AbstractAcceptAction<ACCEPTOR> {

    /**
     * Create an accept action that will do something with dataNode when proper
     * dataFlavor is dropped.
     *
     * @param dataFlavor
     * @param dataNode
     */
    protected StrAbstractAcceptAction(DataFlavor dataFlavor, PoshElement dataNode) {
        super(dataFlavor, (ACCEPTOR) dataNode, null);

    }

    @Override
    protected void performAction(Transferable tr) throws UnsupportedFlavorException, IOException {
        DONOR passedObject = (DONOR) tr.getTransferData(dataFlavor);
        if (passedObject == null) {
            return;
        }
        accept(passedObject);
    }

    /**
     * Take dropped object and do something with it.
     *
     * @param droppedDN, never null, correct dataFlavor
     */
    protected abstract void accept(DONOR droppedDN);
}
